// Copyright 2025 The gVisor Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build !false
// +build !false

package kvm

// Config sets configuration options for each platform instance.
type Config struct {
	// ApplicationCores is the same parameter passed into
	// kernel.InitKernelArgs. It is necessary to forward it to KVM in order
	// to initialize the correct amount of vCPUs.
	ApplicationCores int

	// UseCPUNums use KVM vCPU numbers as CPU numbers in the sentry.
	// This is necessary to support features like RSEQ and CPU preemption detection.
	UseCPUNums bool
}

func (*machine) applyConfig(config *Config) error { return nil }
