// automatically generated by stateify.

package stack

import (
	"context"

	"gvisor.dev/gvisor/pkg/state"
)

func (r *addressStateRefs) StateTypeName() string {
	return "pkg/tcpip/stack.addressStateRefs"
}

func (r *addressStateRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *addressStateRefs) beforeSave() {}

// +checklocksignore
func (r *addressStateRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *addressStateRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (a *AddressableEndpointState) StateTypeName() string {
	return "pkg/tcpip/stack.AddressableEndpointState"
}

func (a *AddressableEndpointState) StateFields() []string {
	return []string{
		"networkEndpoint",
		"options",
	}
}

func (a *AddressableEndpointState) beforeSave() {}

// +checklocksignore
func (a *AddressableEndpointState) StateSave(stateSinkObject state.Sink) {
	a.beforeSave()
	stateSinkObject.Save(0, &a.networkEndpoint)
	stateSinkObject.Save(1, &a.options)
}

func (a *AddressableEndpointState) afterLoad(context.Context) {}

// +checklocksignore
func (a *AddressableEndpointState) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &a.networkEndpoint)
	stateSourceObject.Load(1, &a.options)
}

func (a *AddressableEndpointStateOptions) StateTypeName() string {
	return "pkg/tcpip/stack.AddressableEndpointStateOptions"
}

func (a *AddressableEndpointStateOptions) StateFields() []string {
	return []string{
		"HiddenWhileDisabled",
	}
}

func (a *AddressableEndpointStateOptions) beforeSave() {}

// +checklocksignore
func (a *AddressableEndpointStateOptions) StateSave(stateSinkObject state.Sink) {
	a.beforeSave()
	stateSinkObject.Save(0, &a.HiddenWhileDisabled)
}

func (a *AddressableEndpointStateOptions) afterLoad(context.Context) {}

// +checklocksignore
func (a *AddressableEndpointStateOptions) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &a.HiddenWhileDisabled)
}

func (p *bridgePort) StateTypeName() string {
	return "pkg/tcpip/stack.bridgePort"
}

func (p *bridgePort) StateFields() []string {
	return []string{
		"bridge",
		"nic",
	}
}

func (p *bridgePort) beforeSave() {}

// +checklocksignore
func (p *bridgePort) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.bridge)
	stateSinkObject.Save(1, &p.nic)
}

func (p *bridgePort) afterLoad(context.Context) {}

// +checklocksignore
func (p *bridgePort) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.bridge)
	stateSourceObject.Load(1, &p.nic)
}

func (b *BridgeEndpoint) StateTypeName() string {
	return "pkg/tcpip/stack.BridgeEndpoint"
}

func (b *BridgeEndpoint) StateFields() []string {
	return []string{
		"ports",
		"dispatcher",
		"addr",
		"attached",
		"mtu",
		"fdbTable",
		"maxHeaderLength",
	}
}

func (b *BridgeEndpoint) beforeSave() {}

// +checklocksignore
func (b *BridgeEndpoint) StateSave(stateSinkObject state.Sink) {
	b.beforeSave()
	stateSinkObject.Save(0, &b.ports)
	stateSinkObject.Save(1, &b.dispatcher)
	stateSinkObject.Save(2, &b.addr)
	stateSinkObject.Save(3, &b.attached)
	stateSinkObject.Save(4, &b.mtu)
	stateSinkObject.Save(5, &b.fdbTable)
	stateSinkObject.Save(6, &b.maxHeaderLength)
}

func (b *BridgeEndpoint) afterLoad(context.Context) {}

// +checklocksignore
func (b *BridgeEndpoint) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &b.ports)
	stateSourceObject.Load(1, &b.dispatcher)
	stateSourceObject.Load(2, &b.addr)
	stateSourceObject.Load(3, &b.attached)
	stateSourceObject.Load(4, &b.mtu)
	stateSourceObject.Load(5, &b.fdbTable)
	stateSourceObject.Load(6, &b.maxHeaderLength)
}

func (t *tuple) StateTypeName() string {
	return "pkg/tcpip/stack.tuple"
}

func (t *tuple) StateFields() []string {
	return []string{
		"tupleEntry",
		"conn",
		"reply",
		"tupleID",
	}
}

func (t *tuple) beforeSave() {}

// +checklocksignore
func (t *tuple) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.tupleEntry)
	stateSinkObject.Save(1, &t.conn)
	stateSinkObject.Save(2, &t.reply)
	stateSinkObject.Save(3, &t.tupleID)
}

func (t *tuple) afterLoad(context.Context) {}

// +checklocksignore
func (t *tuple) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.tupleEntry)
	stateSourceObject.Load(1, &t.conn)
	stateSourceObject.Load(2, &t.reply)
	stateSourceObject.Load(3, &t.tupleID)
}

func (ti *tupleID) StateTypeName() string {
	return "pkg/tcpip/stack.tupleID"
}

func (ti *tupleID) StateFields() []string {
	return []string{
		"srcAddr",
		"srcPortOrEchoRequestIdent",
		"dstAddr",
		"dstPortOrEchoReplyIdent",
		"transProto",
		"netProto",
	}
}

func (ti *tupleID) beforeSave() {}

// +checklocksignore
func (ti *tupleID) StateSave(stateSinkObject state.Sink) {
	ti.beforeSave()
	stateSinkObject.Save(0, &ti.srcAddr)
	stateSinkObject.Save(1, &ti.srcPortOrEchoRequestIdent)
	stateSinkObject.Save(2, &ti.dstAddr)
	stateSinkObject.Save(3, &ti.dstPortOrEchoReplyIdent)
	stateSinkObject.Save(4, &ti.transProto)
	stateSinkObject.Save(5, &ti.netProto)
}

func (ti *tupleID) afterLoad(context.Context) {}

// +checklocksignore
func (ti *tupleID) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ti.srcAddr)
	stateSourceObject.Load(1, &ti.srcPortOrEchoRequestIdent)
	stateSourceObject.Load(2, &ti.dstAddr)
	stateSourceObject.Load(3, &ti.dstPortOrEchoReplyIdent)
	stateSourceObject.Load(4, &ti.transProto)
	stateSourceObject.Load(5, &ti.netProto)
}

func (cn *conn) StateTypeName() string {
	return "pkg/tcpip/stack.conn"
}

func (cn *conn) StateFields() []string {
	return []string{
		"ct",
		"original",
		"reply",
		"finalizeResult",
		"sourceManip",
		"destinationManip",
		"tcb",
		"lastUsed",
	}
}

func (cn *conn) beforeSave() {}

// +checklocksignore
func (cn *conn) StateSave(stateSinkObject state.Sink) {
	cn.beforeSave()
	stateSinkObject.Save(0, &cn.ct)
	stateSinkObject.Save(1, &cn.original)
	stateSinkObject.Save(2, &cn.reply)
	stateSinkObject.Save(3, &cn.finalizeResult)
	stateSinkObject.Save(4, &cn.sourceManip)
	stateSinkObject.Save(5, &cn.destinationManip)
	stateSinkObject.Save(6, &cn.tcb)
	stateSinkObject.Save(7, &cn.lastUsed)
}

func (cn *conn) afterLoad(context.Context) {}

// +checklocksignore
func (cn *conn) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &cn.ct)
	stateSourceObject.Load(1, &cn.original)
	stateSourceObject.Load(2, &cn.reply)
	stateSourceObject.Load(3, &cn.finalizeResult)
	stateSourceObject.Load(4, &cn.sourceManip)
	stateSourceObject.Load(5, &cn.destinationManip)
	stateSourceObject.Load(6, &cn.tcb)
	stateSourceObject.Load(7, &cn.lastUsed)
}

func (ct *ConnTrack) StateTypeName() string {
	return "pkg/tcpip/stack.ConnTrack"
}

func (ct *ConnTrack) StateFields() []string {
	return []string{
		"seed",
		"clock",
		"buckets",
	}
}

func (ct *ConnTrack) beforeSave() {}

// +checklocksignore
func (ct *ConnTrack) StateSave(stateSinkObject state.Sink) {
	ct.beforeSave()
	stateSinkObject.Save(0, &ct.seed)
	stateSinkObject.Save(1, &ct.clock)
	stateSinkObject.Save(2, &ct.buckets)
}

func (ct *ConnTrack) afterLoad(context.Context) {}

// +checklocksignore
func (ct *ConnTrack) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ct.seed)
	stateSourceObject.Load(1, &ct.clock)
	stateSourceObject.Load(2, &ct.buckets)
}

func (bkt *bucket) StateTypeName() string {
	return "pkg/tcpip/stack.bucket"
}

func (bkt *bucket) StateFields() []string {
	return []string{
		"tuples",
	}
}

func (bkt *bucket) beforeSave() {}

// +checklocksignore
func (bkt *bucket) StateSave(stateSinkObject state.Sink) {
	bkt.beforeSave()
	stateSinkObject.Save(0, &bkt.tuples)
}

func (bkt *bucket) afterLoad(context.Context) {}

// +checklocksignore
func (bkt *bucket) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &bkt.tuples)
}

func (l *ICMPRateLimiter) StateTypeName() string {
	return "pkg/tcpip/stack.ICMPRateLimiter"
}

func (l *ICMPRateLimiter) StateFields() []string {
	return []string{
		"clock",
	}
}

func (l *ICMPRateLimiter) beforeSave() {}

// +checklocksignore
func (l *ICMPRateLimiter) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.clock)
}

func (l *ICMPRateLimiter) afterLoad(context.Context) {}

// +checklocksignore
func (l *ICMPRateLimiter) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.clock)
}

func (a *AcceptTarget) StateTypeName() string {
	return "pkg/tcpip/stack.AcceptTarget"
}

func (a *AcceptTarget) StateFields() []string {
	return []string{
		"NetworkProtocol",
	}
}

func (a *AcceptTarget) beforeSave() {}

// +checklocksignore
func (a *AcceptTarget) StateSave(stateSinkObject state.Sink) {
	a.beforeSave()
	stateSinkObject.Save(0, &a.NetworkProtocol)
}

func (a *AcceptTarget) afterLoad(context.Context) {}

// +checklocksignore
func (a *AcceptTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &a.NetworkProtocol)
}

func (d *DropTarget) StateTypeName() string {
	return "pkg/tcpip/stack.DropTarget"
}

func (d *DropTarget) StateFields() []string {
	return []string{
		"NetworkProtocol",
	}
}

func (d *DropTarget) beforeSave() {}

// +checklocksignore
func (d *DropTarget) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.NetworkProtocol)
}

func (d *DropTarget) afterLoad(context.Context) {}

// +checklocksignore
func (d *DropTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.NetworkProtocol)
}

func (rt *RejectIPv4Target) StateTypeName() string {
	return "pkg/tcpip/stack.RejectIPv4Target"
}

func (rt *RejectIPv4Target) StateFields() []string {
	return []string{
		"Handler",
		"RejectWith",
	}
}

func (rt *RejectIPv4Target) beforeSave() {}

// +checklocksignore
func (rt *RejectIPv4Target) StateSave(stateSinkObject state.Sink) {
	rt.beforeSave()
	stateSinkObject.Save(0, &rt.Handler)
	stateSinkObject.Save(1, &rt.RejectWith)
}

func (rt *RejectIPv4Target) afterLoad(context.Context) {}

// +checklocksignore
func (rt *RejectIPv4Target) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &rt.Handler)
	stateSourceObject.Load(1, &rt.RejectWith)
}

func (rt *RejectIPv6Target) StateTypeName() string {
	return "pkg/tcpip/stack.RejectIPv6Target"
}

func (rt *RejectIPv6Target) StateFields() []string {
	return []string{
		"Handler",
		"RejectWith",
	}
}

func (rt *RejectIPv6Target) beforeSave() {}

// +checklocksignore
func (rt *RejectIPv6Target) StateSave(stateSinkObject state.Sink) {
	rt.beforeSave()
	stateSinkObject.Save(0, &rt.Handler)
	stateSinkObject.Save(1, &rt.RejectWith)
}

func (rt *RejectIPv6Target) afterLoad(context.Context) {}

// +checklocksignore
func (rt *RejectIPv6Target) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &rt.Handler)
	stateSourceObject.Load(1, &rt.RejectWith)
}

func (e *ErrorTarget) StateTypeName() string {
	return "pkg/tcpip/stack.ErrorTarget"
}

func (e *ErrorTarget) StateFields() []string {
	return []string{
		"NetworkProtocol",
	}
}

func (e *ErrorTarget) beforeSave() {}

// +checklocksignore
func (e *ErrorTarget) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.NetworkProtocol)
}

func (e *ErrorTarget) afterLoad(context.Context) {}

// +checklocksignore
func (e *ErrorTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.NetworkProtocol)
}

func (u *UserChainTarget) StateTypeName() string {
	return "pkg/tcpip/stack.UserChainTarget"
}

func (u *UserChainTarget) StateFields() []string {
	return []string{
		"Name",
		"NetworkProtocol",
	}
}

func (u *UserChainTarget) beforeSave() {}

// +checklocksignore
func (u *UserChainTarget) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	stateSinkObject.Save(0, &u.Name)
	stateSinkObject.Save(1, &u.NetworkProtocol)
}

func (u *UserChainTarget) afterLoad(context.Context) {}

// +checklocksignore
func (u *UserChainTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.Name)
	stateSourceObject.Load(1, &u.NetworkProtocol)
}

func (r *ReturnTarget) StateTypeName() string {
	return "pkg/tcpip/stack.ReturnTarget"
}

func (r *ReturnTarget) StateFields() []string {
	return []string{
		"NetworkProtocol",
	}
}

func (r *ReturnTarget) beforeSave() {}

// +checklocksignore
func (r *ReturnTarget) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.NetworkProtocol)
}

func (r *ReturnTarget) afterLoad(context.Context) {}

// +checklocksignore
func (r *ReturnTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.NetworkProtocol)
}

func (rt *DNATTarget) StateTypeName() string {
	return "pkg/tcpip/stack.DNATTarget"
}

func (rt *DNATTarget) StateFields() []string {
	return []string{
		"Addr",
		"Port",
		"NetworkProtocol",
		"ChangeAddress",
		"ChangePort",
	}
}

func (rt *DNATTarget) beforeSave() {}

// +checklocksignore
func (rt *DNATTarget) StateSave(stateSinkObject state.Sink) {
	rt.beforeSave()
	stateSinkObject.Save(0, &rt.Addr)
	stateSinkObject.Save(1, &rt.Port)
	stateSinkObject.Save(2, &rt.NetworkProtocol)
	stateSinkObject.Save(3, &rt.ChangeAddress)
	stateSinkObject.Save(4, &rt.ChangePort)
}

func (rt *DNATTarget) afterLoad(context.Context) {}

// +checklocksignore
func (rt *DNATTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &rt.Addr)
	stateSourceObject.Load(1, &rt.Port)
	stateSourceObject.Load(2, &rt.NetworkProtocol)
	stateSourceObject.Load(3, &rt.ChangeAddress)
	stateSourceObject.Load(4, &rt.ChangePort)
}

func (rt *RedirectTarget) StateTypeName() string {
	return "pkg/tcpip/stack.RedirectTarget"
}

func (rt *RedirectTarget) StateFields() []string {
	return []string{
		"Port",
		"NetworkProtocol",
	}
}

func (rt *RedirectTarget) beforeSave() {}

// +checklocksignore
func (rt *RedirectTarget) StateSave(stateSinkObject state.Sink) {
	rt.beforeSave()
	stateSinkObject.Save(0, &rt.Port)
	stateSinkObject.Save(1, &rt.NetworkProtocol)
}

func (rt *RedirectTarget) afterLoad(context.Context) {}

// +checklocksignore
func (rt *RedirectTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &rt.Port)
	stateSourceObject.Load(1, &rt.NetworkProtocol)
}

func (st *SNATTarget) StateTypeName() string {
	return "pkg/tcpip/stack.SNATTarget"
}

func (st *SNATTarget) StateFields() []string {
	return []string{
		"Addr",
		"Port",
		"NetworkProtocol",
		"ChangeAddress",
		"ChangePort",
	}
}

func (st *SNATTarget) beforeSave() {}

// +checklocksignore
func (st *SNATTarget) StateSave(stateSinkObject state.Sink) {
	st.beforeSave()
	stateSinkObject.Save(0, &st.Addr)
	stateSinkObject.Save(1, &st.Port)
	stateSinkObject.Save(2, &st.NetworkProtocol)
	stateSinkObject.Save(3, &st.ChangeAddress)
	stateSinkObject.Save(4, &st.ChangePort)
}

func (st *SNATTarget) afterLoad(context.Context) {}

// +checklocksignore
func (st *SNATTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &st.Addr)
	stateSourceObject.Load(1, &st.Port)
	stateSourceObject.Load(2, &st.NetworkProtocol)
	stateSourceObject.Load(3, &st.ChangeAddress)
	stateSourceObject.Load(4, &st.ChangePort)
}

func (mt *MasqueradeTarget) StateTypeName() string {
	return "pkg/tcpip/stack.MasqueradeTarget"
}

func (mt *MasqueradeTarget) StateFields() []string {
	return []string{
		"NetworkProtocol",
	}
}

func (mt *MasqueradeTarget) beforeSave() {}

// +checklocksignore
func (mt *MasqueradeTarget) StateSave(stateSinkObject state.Sink) {
	mt.beforeSave()
	stateSinkObject.Save(0, &mt.NetworkProtocol)
}

func (mt *MasqueradeTarget) afterLoad(context.Context) {}

// +checklocksignore
func (mt *MasqueradeTarget) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &mt.NetworkProtocol)
}

func (it *IPTables) StateTypeName() string {
	return "pkg/tcpip/stack.IPTables"
}

func (it *IPTables) StateFields() []string {
	return []string{
		"connections",
		"v4Tables",
		"v6Tables",
		"modified",
	}
}

// +checklocksignore
func (it *IPTables) StateSave(stateSinkObject state.Sink) {
	it.beforeSave()
	stateSinkObject.Save(0, &it.connections)
	stateSinkObject.Save(1, &it.v4Tables)
	stateSinkObject.Save(2, &it.v6Tables)
	stateSinkObject.Save(3, &it.modified)
}

// +checklocksignore
func (it *IPTables) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &it.connections)
	stateSourceObject.Load(1, &it.v4Tables)
	stateSourceObject.Load(2, &it.v6Tables)
	stateSourceObject.Load(3, &it.modified)
	stateSourceObject.AfterLoad(func() { it.afterLoad(ctx) })
}

func (table *Table) StateTypeName() string {
	return "pkg/tcpip/stack.Table"
}

func (table *Table) StateFields() []string {
	return []string{
		"Rules",
		"BuiltinChains",
		"Underflows",
	}
}

func (table *Table) beforeSave() {}

// +checklocksignore
func (table *Table) StateSave(stateSinkObject state.Sink) {
	table.beforeSave()
	stateSinkObject.Save(0, &table.Rules)
	stateSinkObject.Save(1, &table.BuiltinChains)
	stateSinkObject.Save(2, &table.Underflows)
}

func (table *Table) afterLoad(context.Context) {}

// +checklocksignore
func (table *Table) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &table.Rules)
	stateSourceObject.Load(1, &table.BuiltinChains)
	stateSourceObject.Load(2, &table.Underflows)
}

func (r *Rule) StateTypeName() string {
	return "pkg/tcpip/stack.Rule"
}

func (r *Rule) StateFields() []string {
	return []string{
		"Filter",
		"Matchers",
		"Target",
	}
}

func (r *Rule) beforeSave() {}

// +checklocksignore
func (r *Rule) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.Filter)
	stateSinkObject.Save(1, &r.Matchers)
	stateSinkObject.Save(2, &r.Target)
}

func (r *Rule) afterLoad(context.Context) {}

// +checklocksignore
func (r *Rule) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.Filter)
	stateSourceObject.Load(1, &r.Matchers)
	stateSourceObject.Load(2, &r.Target)
}

func (fl *IPHeaderFilter) StateTypeName() string {
	return "pkg/tcpip/stack.IPHeaderFilter"
}

func (fl *IPHeaderFilter) StateFields() []string {
	return []string{
		"Protocol",
		"CheckProtocol",
		"Dst",
		"DstMask",
		"DstInvert",
		"Src",
		"SrcMask",
		"SrcInvert",
		"InputInterface",
		"InputInterfaceMask",
		"InputInterfaceInvert",
		"OutputInterface",
		"OutputInterfaceMask",
		"OutputInterfaceInvert",
	}
}

func (fl *IPHeaderFilter) beforeSave() {}

// +checklocksignore
func (fl *IPHeaderFilter) StateSave(stateSinkObject state.Sink) {
	fl.beforeSave()
	stateSinkObject.Save(0, &fl.Protocol)
	stateSinkObject.Save(1, &fl.CheckProtocol)
	stateSinkObject.Save(2, &fl.Dst)
	stateSinkObject.Save(3, &fl.DstMask)
	stateSinkObject.Save(4, &fl.DstInvert)
	stateSinkObject.Save(5, &fl.Src)
	stateSinkObject.Save(6, &fl.SrcMask)
	stateSinkObject.Save(7, &fl.SrcInvert)
	stateSinkObject.Save(8, &fl.InputInterface)
	stateSinkObject.Save(9, &fl.InputInterfaceMask)
	stateSinkObject.Save(10, &fl.InputInterfaceInvert)
	stateSinkObject.Save(11, &fl.OutputInterface)
	stateSinkObject.Save(12, &fl.OutputInterfaceMask)
	stateSinkObject.Save(13, &fl.OutputInterfaceInvert)
}

func (fl *IPHeaderFilter) afterLoad(context.Context) {}

// +checklocksignore
func (fl *IPHeaderFilter) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &fl.Protocol)
	stateSourceObject.Load(1, &fl.CheckProtocol)
	stateSourceObject.Load(2, &fl.Dst)
	stateSourceObject.Load(3, &fl.DstMask)
	stateSourceObject.Load(4, &fl.DstInvert)
	stateSourceObject.Load(5, &fl.Src)
	stateSourceObject.Load(6, &fl.SrcMask)
	stateSourceObject.Load(7, &fl.SrcInvert)
	stateSourceObject.Load(8, &fl.InputInterface)
	stateSourceObject.Load(9, &fl.InputInterfaceMask)
	stateSourceObject.Load(10, &fl.InputInterfaceInvert)
	stateSourceObject.Load(11, &fl.OutputInterface)
	stateSourceObject.Load(12, &fl.OutputInterfaceMask)
	stateSourceObject.Load(13, &fl.OutputInterfaceInvert)
}

func (d *dynamicCacheEntry) StateTypeName() string {
	return "pkg/tcpip/stack.dynamicCacheEntry"
}

func (d *dynamicCacheEntry) StateFields() []string {
	return []string{
		"lru",
		"count",
	}
}

func (d *dynamicCacheEntry) beforeSave() {}

// +checklocksignore
func (d *dynamicCacheEntry) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.lru)
	stateSinkObject.Save(1, &d.count)
}

func (d *dynamicCacheEntry) afterLoad(context.Context) {}

// +checklocksignore
func (d *dynamicCacheEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.lru)
	stateSourceObject.Load(1, &d.count)
}

func (n *neighborCacheMu) StateTypeName() string {
	return "pkg/tcpip/stack.neighborCacheMu"
}

func (n *neighborCacheMu) StateFields() []string {
	return []string{
		"cache",
		"dynamic",
	}
}

func (n *neighborCacheMu) beforeSave() {}

// +checklocksignore
func (n *neighborCacheMu) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.cache)
	stateSinkObject.Save(1, &n.dynamic)
}

func (n *neighborCacheMu) afterLoad(context.Context) {}

// +checklocksignore
func (n *neighborCacheMu) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.cache)
	stateSourceObject.Load(1, &n.dynamic)
}

func (n *neighborCache) StateTypeName() string {
	return "pkg/tcpip/stack.neighborCache"
}

func (n *neighborCache) StateFields() []string {
	return []string{
		"nic",
		"state",
		"linkRes",
		"mu",
	}
}

func (n *neighborCache) beforeSave() {}

// +checklocksignore
func (n *neighborCache) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.nic)
	stateSinkObject.Save(1, &n.state)
	stateSinkObject.Save(2, &n.linkRes)
	stateSinkObject.Save(3, &n.mu)
}

func (n *neighborCache) afterLoad(context.Context) {}

// +checklocksignore
func (n *neighborCache) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.nic)
	stateSourceObject.Load(1, &n.state)
	stateSourceObject.Load(2, &n.linkRes)
	stateSourceObject.Load(3, &n.mu)
}

func (n *NeighborEntry) StateTypeName() string {
	return "pkg/tcpip/stack.NeighborEntry"
}

func (n *NeighborEntry) StateFields() []string {
	return []string{
		"Addr",
		"LinkAddr",
		"State",
		"UpdatedAt",
	}
}

func (n *NeighborEntry) beforeSave() {}

// +checklocksignore
func (n *NeighborEntry) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.Addr)
	stateSinkObject.Save(1, &n.LinkAddr)
	stateSinkObject.Save(2, &n.State)
	stateSinkObject.Save(3, &n.UpdatedAt)
}

func (n *NeighborEntry) afterLoad(context.Context) {}

// +checklocksignore
func (n *NeighborEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.Addr)
	stateSourceObject.Load(1, &n.LinkAddr)
	stateSourceObject.Load(2, &n.State)
	stateSourceObject.Load(3, &n.UpdatedAt)
}

func (t *timer) StateTypeName() string {
	return "pkg/tcpip/stack.timer"
}

func (t *timer) StateFields() []string {
	return []string{
		"done",
	}
}

func (t *timer) beforeSave() {}

// +checklocksignore
func (t *timer) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.done)
}

func (t *timer) afterLoad(context.Context) {}

// +checklocksignore
func (t *timer) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.done)
}

func (n *neighborEntryMu) StateTypeName() string {
	return "pkg/tcpip/stack.neighborEntryMu"
}

func (n *neighborEntryMu) StateFields() []string {
	return []string{
		"neigh",
		"isRouter",
		"timer",
	}
}

func (n *neighborEntryMu) beforeSave() {}

// +checklocksignore
func (n *neighborEntryMu) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.neigh)
	stateSinkObject.Save(1, &n.isRouter)
	stateSinkObject.Save(2, &n.timer)
}

func (n *neighborEntryMu) afterLoad(context.Context) {}

// +checklocksignore
func (n *neighborEntryMu) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.neigh)
	stateSourceObject.Load(1, &n.isRouter)
	stateSourceObject.Load(2, &n.timer)
}

func (e *neighborEntry) StateTypeName() string {
	return "pkg/tcpip/stack.neighborEntry"
}

func (e *neighborEntry) StateFields() []string {
	return []string{
		"neighborEntryEntry",
		"cache",
		"nudState",
		"mu",
	}
}

func (e *neighborEntry) beforeSave() {}

// +checklocksignore
func (e *neighborEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.neighborEntryEntry)
	stateSinkObject.Save(1, &e.cache)
	stateSinkObject.Save(2, &e.nudState)
	stateSinkObject.Save(3, &e.mu)
}

func (e *neighborEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *neighborEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.neighborEntryEntry)
	stateSourceObject.Load(1, &e.cache)
	stateSourceObject.Load(2, &e.nudState)
	stateSourceObject.Load(3, &e.mu)
}

func (l *neighborEntryList) StateTypeName() string {
	return "pkg/tcpip/stack.neighborEntryList"
}

func (l *neighborEntryList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *neighborEntryList) beforeSave() {}

// +checklocksignore
func (l *neighborEntryList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *neighborEntryList) afterLoad(context.Context) {}

// +checklocksignore
func (l *neighborEntryList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *neighborEntryEntry) StateTypeName() string {
	return "pkg/tcpip/stack.neighborEntryEntry"
}

func (e *neighborEntryEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *neighborEntryEntry) beforeSave() {}

// +checklocksignore
func (e *neighborEntryEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *neighborEntryEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *neighborEntryEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func (l *linkResolver) StateTypeName() string {
	return "pkg/tcpip/stack.linkResolver"
}

func (l *linkResolver) StateFields() []string {
	return []string{
		"resolver",
		"neigh",
	}
}

func (l *linkResolver) beforeSave() {}

// +checklocksignore
func (l *linkResolver) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.resolver)
	stateSinkObject.Save(1, &l.neigh)
}

func (l *linkResolver) afterLoad(context.Context) {}

// +checklocksignore
func (l *linkResolver) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.resolver)
	stateSourceObject.Load(1, &l.neigh)
}

func (n *nic) StateTypeName() string {
	return "pkg/tcpip/stack.nic"
}

func (n *nic) StateFields() []string {
	return []string{
		"NetworkLinkEndpoint",
		"stack",
		"id",
		"name",
		"context",
		"stats",
		"networkEndpoints",
		"linkAddrResolvers",
		"duplicateAddressDetectors",
		"enabled",
		"spoofing",
		"promiscuous",
		"linkResQueue",
		"packetEPs",
		"qDisc",
		"deliverLinkPackets",
		"Primary",
		"experimentIPOptionEnabled",
	}
}

func (n *nic) beforeSave() {}

// +checklocksignore
func (n *nic) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.NetworkLinkEndpoint)
	stateSinkObject.Save(1, &n.stack)
	stateSinkObject.Save(2, &n.id)
	stateSinkObject.Save(3, &n.name)
	stateSinkObject.Save(4, &n.context)
	stateSinkObject.Save(5, &n.stats)
	stateSinkObject.Save(6, &n.networkEndpoints)
	stateSinkObject.Save(7, &n.linkAddrResolvers)
	stateSinkObject.Save(8, &n.duplicateAddressDetectors)
	stateSinkObject.Save(9, &n.enabled)
	stateSinkObject.Save(10, &n.spoofing)
	stateSinkObject.Save(11, &n.promiscuous)
	stateSinkObject.Save(12, &n.linkResQueue)
	stateSinkObject.Save(13, &n.packetEPs)
	stateSinkObject.Save(14, &n.qDisc)
	stateSinkObject.Save(15, &n.deliverLinkPackets)
	stateSinkObject.Save(16, &n.Primary)
	stateSinkObject.Save(17, &n.experimentIPOptionEnabled)
}

func (n *nic) afterLoad(context.Context) {}

// +checklocksignore
func (n *nic) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.NetworkLinkEndpoint)
	stateSourceObject.Load(1, &n.stack)
	stateSourceObject.Load(2, &n.id)
	stateSourceObject.Load(3, &n.name)
	stateSourceObject.Load(4, &n.context)
	stateSourceObject.Load(5, &n.stats)
	stateSourceObject.Load(6, &n.networkEndpoints)
	stateSourceObject.Load(7, &n.linkAddrResolvers)
	stateSourceObject.Load(8, &n.duplicateAddressDetectors)
	stateSourceObject.Load(9, &n.enabled)
	stateSourceObject.Load(10, &n.spoofing)
	stateSourceObject.Load(11, &n.promiscuous)
	stateSourceObject.Load(12, &n.linkResQueue)
	stateSourceObject.Load(13, &n.packetEPs)
	stateSourceObject.Load(14, &n.qDisc)
	stateSourceObject.Load(15, &n.deliverLinkPackets)
	stateSourceObject.Load(16, &n.Primary)
	stateSourceObject.Load(17, &n.experimentIPOptionEnabled)
}

func (p *packetEndpointList) StateTypeName() string {
	return "pkg/tcpip/stack.packetEndpointList"
}

func (p *packetEndpointList) StateFields() []string {
	return []string{
		"eps",
	}
}

func (p *packetEndpointList) beforeSave() {}

// +checklocksignore
func (p *packetEndpointList) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.eps)
}

func (p *packetEndpointList) afterLoad(context.Context) {}

// +checklocksignore
func (p *packetEndpointList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.eps)
}

func (qDisc *delegatingQueueingDiscipline) StateTypeName() string {
	return "pkg/tcpip/stack.delegatingQueueingDiscipline"
}

func (qDisc *delegatingQueueingDiscipline) StateFields() []string {
	return []string{
		"LinkWriter",
	}
}

func (qDisc *delegatingQueueingDiscipline) beforeSave() {}

// +checklocksignore
func (qDisc *delegatingQueueingDiscipline) StateSave(stateSinkObject state.Sink) {
	qDisc.beforeSave()
	stateSinkObject.Save(0, &qDisc.LinkWriter)
}

func (qDisc *delegatingQueueingDiscipline) afterLoad(context.Context) {}

// +checklocksignore
func (qDisc *delegatingQueueingDiscipline) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &qDisc.LinkWriter)
}

func (s *sharedStats) StateTypeName() string {
	return "pkg/tcpip/stack.sharedStats"
}

func (s *sharedStats) StateFields() []string {
	return []string{
		"local",
		"multiCounterNICStats",
	}
}

func (s *sharedStats) beforeSave() {}

// +checklocksignore
func (s *sharedStats) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.local)
	stateSinkObject.Save(1, &s.multiCounterNICStats)
}

func (s *sharedStats) afterLoad(context.Context) {}

// +checklocksignore
func (s *sharedStats) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.local)
	stateSourceObject.Load(1, &s.multiCounterNICStats)
}

func (m *multiCounterNICPacketStats) StateTypeName() string {
	return "pkg/tcpip/stack.multiCounterNICPacketStats"
}

func (m *multiCounterNICPacketStats) StateFields() []string {
	return []string{
		"packets",
		"bytes",
	}
}

func (m *multiCounterNICPacketStats) beforeSave() {}

// +checklocksignore
func (m *multiCounterNICPacketStats) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.packets)
	stateSinkObject.Save(1, &m.bytes)
}

func (m *multiCounterNICPacketStats) afterLoad(context.Context) {}

// +checklocksignore
func (m *multiCounterNICPacketStats) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.packets)
	stateSourceObject.Load(1, &m.bytes)
}

func (m *multiCounterNICNeighborStats) StateTypeName() string {
	return "pkg/tcpip/stack.multiCounterNICNeighborStats"
}

func (m *multiCounterNICNeighborStats) StateFields() []string {
	return []string{
		"unreachableEntryLookups",
		"droppedConfirmationForNoninitiatedNeighbor",
		"droppedInvalidLinkAddressConfirmations",
	}
}

func (m *multiCounterNICNeighborStats) beforeSave() {}

// +checklocksignore
func (m *multiCounterNICNeighborStats) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.unreachableEntryLookups)
	stateSinkObject.Save(1, &m.droppedConfirmationForNoninitiatedNeighbor)
	stateSinkObject.Save(2, &m.droppedInvalidLinkAddressConfirmations)
}

func (m *multiCounterNICNeighborStats) afterLoad(context.Context) {}

// +checklocksignore
func (m *multiCounterNICNeighborStats) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.unreachableEntryLookups)
	stateSourceObject.Load(1, &m.droppedConfirmationForNoninitiatedNeighbor)
	stateSourceObject.Load(2, &m.droppedInvalidLinkAddressConfirmations)
}

func (m *multiCounterNICStats) StateTypeName() string {
	return "pkg/tcpip/stack.multiCounterNICStats"
}

func (m *multiCounterNICStats) StateFields() []string {
	return []string{
		"unknownL3ProtocolRcvdPacketCounts",
		"unknownL4ProtocolRcvdPacketCounts",
		"malformedL4RcvdPackets",
		"tx",
		"txPacketsDroppedNoBufferSpace",
		"rx",
		"disabledRx",
		"neighbor",
	}
}

func (m *multiCounterNICStats) beforeSave() {}

// +checklocksignore
func (m *multiCounterNICStats) StateSave(stateSinkObject state.Sink) {
	m.beforeSave()
	stateSinkObject.Save(0, &m.unknownL3ProtocolRcvdPacketCounts)
	stateSinkObject.Save(1, &m.unknownL4ProtocolRcvdPacketCounts)
	stateSinkObject.Save(2, &m.malformedL4RcvdPackets)
	stateSinkObject.Save(3, &m.tx)
	stateSinkObject.Save(4, &m.txPacketsDroppedNoBufferSpace)
	stateSinkObject.Save(5, &m.rx)
	stateSinkObject.Save(6, &m.disabledRx)
	stateSinkObject.Save(7, &m.neighbor)
}

func (m *multiCounterNICStats) afterLoad(context.Context) {}

// +checklocksignore
func (m *multiCounterNICStats) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &m.unknownL3ProtocolRcvdPacketCounts)
	stateSourceObject.Load(1, &m.unknownL4ProtocolRcvdPacketCounts)
	stateSourceObject.Load(2, &m.malformedL4RcvdPackets)
	stateSourceObject.Load(3, &m.tx)
	stateSourceObject.Load(4, &m.txPacketsDroppedNoBufferSpace)
	stateSourceObject.Load(5, &m.rx)
	stateSourceObject.Load(6, &m.disabledRx)
	stateSourceObject.Load(7, &m.neighbor)
}

func (c *NUDConfigurations) StateTypeName() string {
	return "pkg/tcpip/stack.NUDConfigurations"
}

func (c *NUDConfigurations) StateFields() []string {
	return []string{
		"BaseReachableTime",
		"LearnBaseReachableTime",
		"MinRandomFactor",
		"MaxRandomFactor",
		"RetransmitTimer",
		"LearnRetransmitTimer",
		"DelayFirstProbeTime",
		"MaxMulticastProbes",
		"MaxUnicastProbes",
		"MaxAnycastDelayTime",
		"MaxReachabilityConfirmations",
	}
}

func (c *NUDConfigurations) beforeSave() {}

// +checklocksignore
func (c *NUDConfigurations) StateSave(stateSinkObject state.Sink) {
	c.beforeSave()
	stateSinkObject.Save(0, &c.BaseReachableTime)
	stateSinkObject.Save(1, &c.LearnBaseReachableTime)
	stateSinkObject.Save(2, &c.MinRandomFactor)
	stateSinkObject.Save(3, &c.MaxRandomFactor)
	stateSinkObject.Save(4, &c.RetransmitTimer)
	stateSinkObject.Save(5, &c.LearnRetransmitTimer)
	stateSinkObject.Save(6, &c.DelayFirstProbeTime)
	stateSinkObject.Save(7, &c.MaxMulticastProbes)
	stateSinkObject.Save(8, &c.MaxUnicastProbes)
	stateSinkObject.Save(9, &c.MaxAnycastDelayTime)
	stateSinkObject.Save(10, &c.MaxReachabilityConfirmations)
}

func (c *NUDConfigurations) afterLoad(context.Context) {}

// +checklocksignore
func (c *NUDConfigurations) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &c.BaseReachableTime)
	stateSourceObject.Load(1, &c.LearnBaseReachableTime)
	stateSourceObject.Load(2, &c.MinRandomFactor)
	stateSourceObject.Load(3, &c.MaxRandomFactor)
	stateSourceObject.Load(4, &c.RetransmitTimer)
	stateSourceObject.Load(5, &c.LearnRetransmitTimer)
	stateSourceObject.Load(6, &c.DelayFirstProbeTime)
	stateSourceObject.Load(7, &c.MaxMulticastProbes)
	stateSourceObject.Load(8, &c.MaxUnicastProbes)
	stateSourceObject.Load(9, &c.MaxAnycastDelayTime)
	stateSourceObject.Load(10, &c.MaxReachabilityConfirmations)
}

func (n *nudStateMu) StateTypeName() string {
	return "pkg/tcpip/stack.nudStateMu"
}

func (n *nudStateMu) StateFields() []string {
	return []string{
		"config",
		"reachableTime",
		"expiration",
		"prevBaseReachableTime",
		"prevMinRandomFactor",
		"prevMaxRandomFactor",
	}
}

func (n *nudStateMu) beforeSave() {}

// +checklocksignore
func (n *nudStateMu) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.config)
	stateSinkObject.Save(1, &n.reachableTime)
	stateSinkObject.Save(2, &n.expiration)
	stateSinkObject.Save(3, &n.prevBaseReachableTime)
	stateSinkObject.Save(4, &n.prevMinRandomFactor)
	stateSinkObject.Save(5, &n.prevMaxRandomFactor)
}

func (n *nudStateMu) afterLoad(context.Context) {}

// +checklocksignore
func (n *nudStateMu) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.config)
	stateSourceObject.Load(1, &n.reachableTime)
	stateSourceObject.Load(2, &n.expiration)
	stateSourceObject.Load(3, &n.prevBaseReachableTime)
	stateSourceObject.Load(4, &n.prevMinRandomFactor)
	stateSourceObject.Load(5, &n.prevMaxRandomFactor)
}

func (s *NUDState) StateTypeName() string {
	return "pkg/tcpip/stack.NUDState"
}

func (s *NUDState) StateFields() []string {
	return []string{
		"clock",
		"mu",
	}
}

func (s *NUDState) beforeSave() {}

// +checklocksignore
func (s *NUDState) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.clock)
	stateSinkObject.Save(1, &s.mu)
}

func (s *NUDState) afterLoad(context.Context) {}

// +checklocksignore
func (s *NUDState) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.clock)
	stateSourceObject.Load(1, &s.mu)
}

func (pk *PacketBuffer) StateTypeName() string {
	return "pkg/tcpip/stack.PacketBuffer"
}

func (pk *PacketBuffer) StateFields() []string {
	return []string{
		"packetBufferRefs",
		"buf",
		"reserved",
		"pushed",
		"consumed",
		"headers",
		"NetworkProtocolNumber",
		"TransportProtocolNumber",
		"Hash",
		"Owner",
		"EgressRoute",
		"GSOOptions",
		"snatDone",
		"dnatDone",
		"PktType",
		"NICID",
		"RXChecksumValidated",
		"NetworkPacketInfo",
		"tuple",
	}
}

func (pk *PacketBuffer) beforeSave() {}

// +checklocksignore
func (pk *PacketBuffer) StateSave(stateSinkObject state.Sink) {
	pk.beforeSave()
	stateSinkObject.Save(0, &pk.packetBufferRefs)
	stateSinkObject.Save(1, &pk.buf)
	stateSinkObject.Save(2, &pk.reserved)
	stateSinkObject.Save(3, &pk.pushed)
	stateSinkObject.Save(4, &pk.consumed)
	stateSinkObject.Save(5, &pk.headers)
	stateSinkObject.Save(6, &pk.NetworkProtocolNumber)
	stateSinkObject.Save(7, &pk.TransportProtocolNumber)
	stateSinkObject.Save(8, &pk.Hash)
	stateSinkObject.Save(9, &pk.Owner)
	stateSinkObject.Save(10, &pk.EgressRoute)
	stateSinkObject.Save(11, &pk.GSOOptions)
	stateSinkObject.Save(12, &pk.snatDone)
	stateSinkObject.Save(13, &pk.dnatDone)
	stateSinkObject.Save(14, &pk.PktType)
	stateSinkObject.Save(15, &pk.NICID)
	stateSinkObject.Save(16, &pk.RXChecksumValidated)
	stateSinkObject.Save(17, &pk.NetworkPacketInfo)
	stateSinkObject.Save(18, &pk.tuple)
}

func (pk *PacketBuffer) afterLoad(context.Context) {}

// +checklocksignore
func (pk *PacketBuffer) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &pk.packetBufferRefs)
	stateSourceObject.Load(1, &pk.buf)
	stateSourceObject.Load(2, &pk.reserved)
	stateSourceObject.Load(3, &pk.pushed)
	stateSourceObject.Load(4, &pk.consumed)
	stateSourceObject.Load(5, &pk.headers)
	stateSourceObject.Load(6, &pk.NetworkProtocolNumber)
	stateSourceObject.Load(7, &pk.TransportProtocolNumber)
	stateSourceObject.Load(8, &pk.Hash)
	stateSourceObject.Load(9, &pk.Owner)
	stateSourceObject.Load(10, &pk.EgressRoute)
	stateSourceObject.Load(11, &pk.GSOOptions)
	stateSourceObject.Load(12, &pk.snatDone)
	stateSourceObject.Load(13, &pk.dnatDone)
	stateSourceObject.Load(14, &pk.PktType)
	stateSourceObject.Load(15, &pk.NICID)
	stateSourceObject.Load(16, &pk.RXChecksumValidated)
	stateSourceObject.Load(17, &pk.NetworkPacketInfo)
	stateSourceObject.Load(18, &pk.tuple)
}

func (h *headerInfo) StateTypeName() string {
	return "pkg/tcpip/stack.headerInfo"
}

func (h *headerInfo) StateFields() []string {
	return []string{
		"offset",
		"length",
	}
}

func (h *headerInfo) beforeSave() {}

// +checklocksignore
func (h *headerInfo) StateSave(stateSinkObject state.Sink) {
	h.beforeSave()
	stateSinkObject.Save(0, &h.offset)
	stateSinkObject.Save(1, &h.length)
}

func (h *headerInfo) afterLoad(context.Context) {}

// +checklocksignore
func (h *headerInfo) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &h.offset)
	stateSourceObject.Load(1, &h.length)
}

func (d *PacketData) StateTypeName() string {
	return "pkg/tcpip/stack.PacketData"
}

func (d *PacketData) StateFields() []string {
	return []string{
		"pk",
	}
}

func (d *PacketData) beforeSave() {}

// +checklocksignore
func (d *PacketData) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.pk)
}

func (d *PacketData) afterLoad(context.Context) {}

// +checklocksignore
func (d *PacketData) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.pk)
}

func (pl *PacketBufferList) StateTypeName() string {
	return "pkg/tcpip/stack.PacketBufferList"
}

func (pl *PacketBufferList) StateFields() []string {
	return []string{
		"pbs",
	}
}

func (pl *PacketBufferList) beforeSave() {}

// +checklocksignore
func (pl *PacketBufferList) StateSave(stateSinkObject state.Sink) {
	pl.beforeSave()
	stateSinkObject.Save(0, &pl.pbs)
}

func (pl *PacketBufferList) afterLoad(context.Context) {}

// +checklocksignore
func (pl *PacketBufferList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &pl.pbs)
}

func (r *packetBufferRefs) StateTypeName() string {
	return "pkg/tcpip/stack.packetBufferRefs"
}

func (r *packetBufferRefs) StateFields() []string {
	return []string{
		"refCount",
	}
}

func (r *packetBufferRefs) beforeSave() {}

// +checklocksignore
func (r *packetBufferRefs) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.refCount)
}

// +checklocksignore
func (r *packetBufferRefs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.refCount)
	stateSourceObject.AfterLoad(func() { r.afterLoad(ctx) })
}

func (p *pendingPacket) StateTypeName() string {
	return "pkg/tcpip/stack.pendingPacket"
}

func (p *pendingPacket) StateFields() []string {
	return []string{
		"routeInfo",
		"pkt",
	}
}

func (p *pendingPacket) beforeSave() {}

// +checklocksignore
func (p *pendingPacket) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.routeInfo)
	stateSinkObject.Save(1, &p.pkt)
}

func (p *pendingPacket) afterLoad(context.Context) {}

// +checklocksignore
func (p *pendingPacket) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.routeInfo)
	stateSourceObject.Load(1, &p.pkt)
}

func (f *packetsPendingLinkResolution) StateTypeName() string {
	return "pkg/tcpip/stack.packetsPendingLinkResolution"
}

func (f *packetsPendingLinkResolution) StateFields() []string {
	return []string{
		"nic",
	}
}

func (f *packetsPendingLinkResolution) beforeSave() {}

// +checklocksignore
func (f *packetsPendingLinkResolution) StateSave(stateSinkObject state.Sink) {
	f.beforeSave()
	stateSinkObject.Save(0, &f.nic)
}

func (f *packetsPendingLinkResolution) afterLoad(context.Context) {}

// +checklocksignore
func (f *packetsPendingLinkResolution) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &f.nic)
}

func (t *TransportEndpointID) StateTypeName() string {
	return "pkg/tcpip/stack.TransportEndpointID"
}

func (t *TransportEndpointID) StateFields() []string {
	return []string{
		"LocalPort",
		"LocalAddress",
		"RemotePort",
		"RemoteAddress",
	}
}

func (t *TransportEndpointID) beforeSave() {}

// +checklocksignore
func (t *TransportEndpointID) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.LocalPort)
	stateSinkObject.Save(1, &t.LocalAddress)
	stateSinkObject.Save(2, &t.RemotePort)
	stateSinkObject.Save(3, &t.RemoteAddress)
}

func (t *TransportEndpointID) afterLoad(context.Context) {}

// +checklocksignore
func (t *TransportEndpointID) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.LocalPort)
	stateSourceObject.Load(1, &t.LocalAddress)
	stateSourceObject.Load(2, &t.RemotePort)
	stateSourceObject.Load(3, &t.RemoteAddress)
}

func (n *NetworkPacketInfo) StateTypeName() string {
	return "pkg/tcpip/stack.NetworkPacketInfo"
}

func (n *NetworkPacketInfo) StateFields() []string {
	return []string{
		"LocalAddressBroadcast",
		"LocalAddressTemporary",
		"IsForwardedPacket",
	}
}

func (n *NetworkPacketInfo) beforeSave() {}

// +checklocksignore
func (n *NetworkPacketInfo) StateSave(stateSinkObject state.Sink) {
	n.beforeSave()
	stateSinkObject.Save(0, &n.LocalAddressBroadcast)
	stateSinkObject.Save(1, &n.LocalAddressTemporary)
	stateSinkObject.Save(2, &n.IsForwardedPacket)
}

func (n *NetworkPacketInfo) afterLoad(context.Context) {}

// +checklocksignore
func (n *NetworkPacketInfo) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &n.LocalAddressBroadcast)
	stateSourceObject.Load(1, &n.LocalAddressTemporary)
	stateSourceObject.Load(2, &n.IsForwardedPacket)
}

func (p *PacketMMapOpts) StateTypeName() string {
	return "pkg/tcpip/stack.PacketMMapOpts"
}

func (p *PacketMMapOpts) StateFields() []string {
	return []string{
		"Req",
		"IsRx",
		"Cooked",
		"Stack",
		"Wq",
		"PacketEndpoint",
		"Version",
		"Reserve",
	}
}

func (p *PacketMMapOpts) beforeSave() {}

// +checklocksignore
func (p *PacketMMapOpts) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.Req)
	stateSinkObject.Save(1, &p.IsRx)
	stateSinkObject.Save(2, &p.Cooked)
	stateSinkObject.Save(3, &p.Stack)
	stateSinkObject.Save(4, &p.Wq)
	stateSinkObject.Save(5, &p.PacketEndpoint)
	stateSinkObject.Save(6, &p.Version)
	stateSinkObject.Save(7, &p.Reserve)
}

func (p *PacketMMapOpts) afterLoad(context.Context) {}

// +checklocksignore
func (p *PacketMMapOpts) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.Req)
	stateSourceObject.Load(1, &p.IsRx)
	stateSourceObject.Load(2, &p.Cooked)
	stateSourceObject.Load(3, &p.Stack)
	stateSourceObject.Load(4, &p.Wq)
	stateSourceObject.Load(5, &p.PacketEndpoint)
	stateSourceObject.Load(6, &p.Version)
	stateSourceObject.Load(7, &p.Reserve)
}

func (lifetimes *AddressLifetimes) StateTypeName() string {
	return "pkg/tcpip/stack.AddressLifetimes"
}

func (lifetimes *AddressLifetimes) StateFields() []string {
	return []string{
		"Deprecated",
		"PreferredUntil",
		"ValidUntil",
	}
}

func (lifetimes *AddressLifetimes) beforeSave() {}

// +checklocksignore
func (lifetimes *AddressLifetimes) StateSave(stateSinkObject state.Sink) {
	lifetimes.beforeSave()
	stateSinkObject.Save(0, &lifetimes.Deprecated)
	stateSinkObject.Save(1, &lifetimes.PreferredUntil)
	stateSinkObject.Save(2, &lifetimes.ValidUntil)
}

func (lifetimes *AddressLifetimes) afterLoad(context.Context) {}

// +checklocksignore
func (lifetimes *AddressLifetimes) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &lifetimes.Deprecated)
	stateSourceObject.Load(1, &lifetimes.PreferredUntil)
	stateSourceObject.Load(2, &lifetimes.ValidUntil)
}

func (u *UnicastSourceAndMulticastDestination) StateTypeName() string {
	return "pkg/tcpip/stack.UnicastSourceAndMulticastDestination"
}

func (u *UnicastSourceAndMulticastDestination) StateFields() []string {
	return []string{
		"Source",
		"Destination",
	}
}

func (u *UnicastSourceAndMulticastDestination) beforeSave() {}

// +checklocksignore
func (u *UnicastSourceAndMulticastDestination) StateSave(stateSinkObject state.Sink) {
	u.beforeSave()
	stateSinkObject.Save(0, &u.Source)
	stateSinkObject.Save(1, &u.Destination)
}

func (u *UnicastSourceAndMulticastDestination) afterLoad(context.Context) {}

// +checklocksignore
func (u *UnicastSourceAndMulticastDestination) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &u.Source)
	stateSourceObject.Load(1, &u.Destination)
}

func (c *DADConfigurations) StateTypeName() string {
	return "pkg/tcpip/stack.DADConfigurations"
}

func (c *DADConfigurations) StateFields() []string {
	return []string{
		"DupAddrDetectTransmits",
		"RetransmitTimer",
	}
}

func (c *DADConfigurations) beforeSave() {}

// +checklocksignore
func (c *DADConfigurations) StateSave(stateSinkObject state.Sink) {
	c.beforeSave()
	stateSinkObject.Save(0, &c.DupAddrDetectTransmits)
	stateSinkObject.Save(1, &c.RetransmitTimer)
}

func (c *DADConfigurations) afterLoad(context.Context) {}

// +checklocksignore
func (c *DADConfigurations) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &c.DupAddrDetectTransmits)
	stateSourceObject.Load(1, &c.RetransmitTimer)
}

func (g *GSOType) StateTypeName() string {
	return "pkg/tcpip/stack.GSOType"
}

func (g *GSOType) StateFields() []string {
	return nil
}

func (g *GSO) StateTypeName() string {
	return "pkg/tcpip/stack.GSO"
}

func (g *GSO) StateFields() []string {
	return []string{
		"Type",
		"NeedsCsum",
		"CsumOffset",
		"MSS",
		"L3HdrLen",
		"MaxSize",
	}
}

func (g *GSO) beforeSave() {}

// +checklocksignore
func (g *GSO) StateSave(stateSinkObject state.Sink) {
	g.beforeSave()
	stateSinkObject.Save(0, &g.Type)
	stateSinkObject.Save(1, &g.NeedsCsum)
	stateSinkObject.Save(2, &g.CsumOffset)
	stateSinkObject.Save(3, &g.MSS)
	stateSinkObject.Save(4, &g.L3HdrLen)
	stateSinkObject.Save(5, &g.MaxSize)
}

func (g *GSO) afterLoad(context.Context) {}

// +checklocksignore
func (g *GSO) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &g.Type)
	stateSourceObject.Load(1, &g.NeedsCsum)
	stateSourceObject.Load(2, &g.CsumOffset)
	stateSourceObject.Load(3, &g.MSS)
	stateSourceObject.Load(4, &g.L3HdrLen)
	stateSourceObject.Load(5, &g.MaxSize)
}

func (r *routeInfo) StateTypeName() string {
	return "pkg/tcpip/stack.routeInfo"
}

func (r *routeInfo) StateFields() []string {
	return []string{
		"RemoteAddress",
		"LocalAddress",
		"LocalLinkAddress",
		"NextHop",
		"NetProto",
		"Loop",
	}
}

func (r *routeInfo) beforeSave() {}

// +checklocksignore
func (r *routeInfo) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.RemoteAddress)
	stateSinkObject.Save(1, &r.LocalAddress)
	stateSinkObject.Save(2, &r.LocalLinkAddress)
	stateSinkObject.Save(3, &r.NextHop)
	stateSinkObject.Save(4, &r.NetProto)
	stateSinkObject.Save(5, &r.Loop)
}

func (r *routeInfo) afterLoad(context.Context) {}

// +checklocksignore
func (r *routeInfo) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.RemoteAddress)
	stateSourceObject.Load(1, &r.LocalAddress)
	stateSourceObject.Load(2, &r.LocalLinkAddress)
	stateSourceObject.Load(3, &r.NextHop)
	stateSourceObject.Load(4, &r.NetProto)
	stateSourceObject.Load(5, &r.Loop)
}

func (r *RouteInfo) StateTypeName() string {
	return "pkg/tcpip/stack.RouteInfo"
}

func (r *RouteInfo) StateFields() []string {
	return []string{
		"routeInfo",
		"RemoteLinkAddress",
	}
}

func (r *RouteInfo) beforeSave() {}

// +checklocksignore
func (r *RouteInfo) StateSave(stateSinkObject state.Sink) {
	r.beforeSave()
	stateSinkObject.Save(0, &r.routeInfo)
	stateSinkObject.Save(1, &r.RemoteLinkAddress)
}

func (r *RouteInfo) afterLoad(context.Context) {}

// +checklocksignore
func (r *RouteInfo) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &r.routeInfo)
	stateSourceObject.Load(1, &r.RemoteLinkAddress)
}

func (t *transportProtocolState) StateTypeName() string {
	return "pkg/tcpip/stack.transportProtocolState"
}

func (t *transportProtocolState) StateFields() []string {
	return []string{
		"proto",
	}
}

func (t *transportProtocolState) beforeSave() {}

// +checklocksignore
func (t *transportProtocolState) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.proto)
}

func (t *transportProtocolState) afterLoad(context.Context) {}

// +checklocksignore
func (t *transportProtocolState) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.proto)
}

func (s *Stack) StateTypeName() string {
	return "pkg/tcpip/stack.Stack"
}

func (s *Stack) StateFields() []string {
	return []string{
		"transportProtocols",
		"networkProtocols",
		"rawFactory",
		"packetEndpointWriteSupported",
		"demux",
		"stats",
		"defaultForwardingEnabled",
		"cleanupEndpoints",
		"PortManager",
		"clock",
		"handleLocal",
		"nftablesConfigured",
		"restoredEndpoints",
		"resumableEndpoints",
		"icmpRateLimiter",
		"seed",
		"nudConfigs",
		"nudDisp",
		"sendBufferSize",
		"receiveBufferSize",
		"tcpInvalidRateLimit",
		"tsOffsetSecret",
		"saveRestoreEnabled",
	}
}

// +checklocksignore
func (s *Stack) StateSave(stateSinkObject state.Sink) {
	s.beforeSave()
	stateSinkObject.Save(0, &s.transportProtocols)
	stateSinkObject.Save(1, &s.networkProtocols)
	stateSinkObject.Save(2, &s.rawFactory)
	stateSinkObject.Save(3, &s.packetEndpointWriteSupported)
	stateSinkObject.Save(4, &s.demux)
	stateSinkObject.Save(5, &s.stats)
	stateSinkObject.Save(6, &s.defaultForwardingEnabled)
	stateSinkObject.Save(7, &s.cleanupEndpoints)
	stateSinkObject.Save(8, &s.PortManager)
	stateSinkObject.Save(9, &s.clock)
	stateSinkObject.Save(10, &s.handleLocal)
	stateSinkObject.Save(11, &s.nftablesConfigured)
	stateSinkObject.Save(12, &s.restoredEndpoints)
	stateSinkObject.Save(13, &s.resumableEndpoints)
	stateSinkObject.Save(14, &s.icmpRateLimiter)
	stateSinkObject.Save(15, &s.seed)
	stateSinkObject.Save(16, &s.nudConfigs)
	stateSinkObject.Save(17, &s.nudDisp)
	stateSinkObject.Save(18, &s.sendBufferSize)
	stateSinkObject.Save(19, &s.receiveBufferSize)
	stateSinkObject.Save(20, &s.tcpInvalidRateLimit)
	stateSinkObject.Save(21, &s.tsOffsetSecret)
	stateSinkObject.Save(22, &s.saveRestoreEnabled)
}

// +checklocksignore
func (s *Stack) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &s.transportProtocols)
	stateSourceObject.Load(1, &s.networkProtocols)
	stateSourceObject.Load(2, &s.rawFactory)
	stateSourceObject.Load(3, &s.packetEndpointWriteSupported)
	stateSourceObject.Load(4, &s.demux)
	stateSourceObject.Load(5, &s.stats)
	stateSourceObject.Load(6, &s.defaultForwardingEnabled)
	stateSourceObject.Load(7, &s.cleanupEndpoints)
	stateSourceObject.Load(8, &s.PortManager)
	stateSourceObject.Load(9, &s.clock)
	stateSourceObject.Load(10, &s.handleLocal)
	stateSourceObject.Load(11, &s.nftablesConfigured)
	stateSourceObject.Load(12, &s.restoredEndpoints)
	stateSourceObject.Load(13, &s.resumableEndpoints)
	stateSourceObject.Load(14, &s.icmpRateLimiter)
	stateSourceObject.Load(15, &s.seed)
	stateSourceObject.Load(16, &s.nudConfigs)
	stateSourceObject.Load(17, &s.nudDisp)
	stateSourceObject.Load(18, &s.sendBufferSize)
	stateSourceObject.Load(19, &s.receiveBufferSize)
	stateSourceObject.Load(20, &s.tcpInvalidRateLimit)
	stateSourceObject.Load(21, &s.tsOffsetSecret)
	stateSourceObject.Load(22, &s.saveRestoreEnabled)
	stateSourceObject.AfterLoad(func() { s.afterLoad(ctx) })
}

func (t *TransportEndpointInfo) StateTypeName() string {
	return "pkg/tcpip/stack.TransportEndpointInfo"
}

func (t *TransportEndpointInfo) StateFields() []string {
	return []string{
		"NetProto",
		"TransProto",
		"ID",
		"BindNICID",
		"BindAddr",
		"RegisterNICID",
	}
}

func (t *TransportEndpointInfo) beforeSave() {}

// +checklocksignore
func (t *TransportEndpointInfo) StateSave(stateSinkObject state.Sink) {
	t.beforeSave()
	stateSinkObject.Save(0, &t.NetProto)
	stateSinkObject.Save(1, &t.TransProto)
	stateSinkObject.Save(2, &t.ID)
	stateSinkObject.Save(3, &t.BindNICID)
	stateSinkObject.Save(4, &t.BindAddr)
	stateSinkObject.Save(5, &t.RegisterNICID)
}

func (t *TransportEndpointInfo) afterLoad(context.Context) {}

// +checklocksignore
func (t *TransportEndpointInfo) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &t.NetProto)
	stateSourceObject.Load(1, &t.TransProto)
	stateSourceObject.Load(2, &t.ID)
	stateSourceObject.Load(3, &t.BindNICID)
	stateSourceObject.Load(4, &t.BindAddr)
	stateSourceObject.Load(5, &t.RegisterNICID)
}

func (p *protocolIDs) StateTypeName() string {
	return "pkg/tcpip/stack.protocolIDs"
}

func (p *protocolIDs) StateFields() []string {
	return []string{
		"network",
		"transport",
	}
}

func (p *protocolIDs) beforeSave() {}

// +checklocksignore
func (p *protocolIDs) StateSave(stateSinkObject state.Sink) {
	p.beforeSave()
	stateSinkObject.Save(0, &p.network)
	stateSinkObject.Save(1, &p.transport)
}

func (p *protocolIDs) afterLoad(context.Context) {}

// +checklocksignore
func (p *protocolIDs) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &p.network)
	stateSourceObject.Load(1, &p.transport)
}

func (eps *transportEndpoints) StateTypeName() string {
	return "pkg/tcpip/stack.transportEndpoints"
}

func (eps *transportEndpoints) StateFields() []string {
	return []string{
		"endpoints",
		"rawEndpoints",
	}
}

func (eps *transportEndpoints) beforeSave() {}

// +checklocksignore
func (eps *transportEndpoints) StateSave(stateSinkObject state.Sink) {
	eps.beforeSave()
	stateSinkObject.Save(0, &eps.endpoints)
	stateSinkObject.Save(1, &eps.rawEndpoints)
}

func (eps *transportEndpoints) afterLoad(context.Context) {}

// +checklocksignore
func (eps *transportEndpoints) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &eps.endpoints)
	stateSourceObject.Load(1, &eps.rawEndpoints)
}

func (epsByNIC *endpointsByNIC) StateTypeName() string {
	return "pkg/tcpip/stack.endpointsByNIC"
}

func (epsByNIC *endpointsByNIC) StateFields() []string {
	return []string{
		"seed",
		"endpoints",
	}
}

func (epsByNIC *endpointsByNIC) beforeSave() {}

// +checklocksignore
func (epsByNIC *endpointsByNIC) StateSave(stateSinkObject state.Sink) {
	epsByNIC.beforeSave()
	stateSinkObject.Save(0, &epsByNIC.seed)
	stateSinkObject.Save(1, &epsByNIC.endpoints)
}

func (epsByNIC *endpointsByNIC) afterLoad(context.Context) {}

// +checklocksignore
func (epsByNIC *endpointsByNIC) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &epsByNIC.seed)
	stateSourceObject.Load(1, &epsByNIC.endpoints)
}

func (d *transportDemuxer) StateTypeName() string {
	return "pkg/tcpip/stack.transportDemuxer"
}

func (d *transportDemuxer) StateFields() []string {
	return []string{
		"stack",
		"protocol",
		"queuedProtocols",
	}
}

func (d *transportDemuxer) beforeSave() {}

// +checklocksignore
func (d *transportDemuxer) StateSave(stateSinkObject state.Sink) {
	d.beforeSave()
	stateSinkObject.Save(0, &d.stack)
	stateSinkObject.Save(1, &d.protocol)
	stateSinkObject.Save(2, &d.queuedProtocols)
}

func (d *transportDemuxer) afterLoad(context.Context) {}

// +checklocksignore
func (d *transportDemuxer) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &d.stack)
	stateSourceObject.Load(1, &d.protocol)
	stateSourceObject.Load(2, &d.queuedProtocols)
}

func (ep *multiPortEndpoint) StateTypeName() string {
	return "pkg/tcpip/stack.multiPortEndpoint"
}

func (ep *multiPortEndpoint) StateFields() []string {
	return []string{
		"demux",
		"netProto",
		"transProto",
		"flags",
		"endpoints",
	}
}

func (ep *multiPortEndpoint) beforeSave() {}

// +checklocksignore
func (ep *multiPortEndpoint) StateSave(stateSinkObject state.Sink) {
	ep.beforeSave()
	stateSinkObject.Save(0, &ep.demux)
	stateSinkObject.Save(1, &ep.netProto)
	stateSinkObject.Save(2, &ep.transProto)
	stateSinkObject.Save(3, &ep.flags)
	stateSinkObject.Save(4, &ep.endpoints)
}

func (ep *multiPortEndpoint) afterLoad(context.Context) {}

// +checklocksignore
func (ep *multiPortEndpoint) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &ep.demux)
	stateSourceObject.Load(1, &ep.netProto)
	stateSourceObject.Load(2, &ep.transProto)
	stateSourceObject.Load(3, &ep.flags)
	stateSourceObject.Load(4, &ep.endpoints)
}

func (l *tupleList) StateTypeName() string {
	return "pkg/tcpip/stack.tupleList"
}

func (l *tupleList) StateFields() []string {
	return []string{
		"head",
		"tail",
	}
}

func (l *tupleList) beforeSave() {}

// +checklocksignore
func (l *tupleList) StateSave(stateSinkObject state.Sink) {
	l.beforeSave()
	stateSinkObject.Save(0, &l.head)
	stateSinkObject.Save(1, &l.tail)
}

func (l *tupleList) afterLoad(context.Context) {}

// +checklocksignore
func (l *tupleList) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &l.head)
	stateSourceObject.Load(1, &l.tail)
}

func (e *tupleEntry) StateTypeName() string {
	return "pkg/tcpip/stack.tupleEntry"
}

func (e *tupleEntry) StateFields() []string {
	return []string{
		"next",
		"prev",
	}
}

func (e *tupleEntry) beforeSave() {}

// +checklocksignore
func (e *tupleEntry) StateSave(stateSinkObject state.Sink) {
	e.beforeSave()
	stateSinkObject.Save(0, &e.next)
	stateSinkObject.Save(1, &e.prev)
}

func (e *tupleEntry) afterLoad(context.Context) {}

// +checklocksignore
func (e *tupleEntry) StateLoad(ctx context.Context, stateSourceObject state.Source) {
	stateSourceObject.Load(0, &e.next)
	stateSourceObject.Load(1, &e.prev)
}

func init() {
	state.Register((*addressStateRefs)(nil))
	state.Register((*AddressableEndpointState)(nil))
	state.Register((*AddressableEndpointStateOptions)(nil))
	state.Register((*bridgePort)(nil))
	state.Register((*BridgeEndpoint)(nil))
	state.Register((*tuple)(nil))
	state.Register((*tupleID)(nil))
	state.Register((*conn)(nil))
	state.Register((*ConnTrack)(nil))
	state.Register((*bucket)(nil))
	state.Register((*ICMPRateLimiter)(nil))
	state.Register((*AcceptTarget)(nil))
	state.Register((*DropTarget)(nil))
	state.Register((*RejectIPv4Target)(nil))
	state.Register((*RejectIPv6Target)(nil))
	state.Register((*ErrorTarget)(nil))
	state.Register((*UserChainTarget)(nil))
	state.Register((*ReturnTarget)(nil))
	state.Register((*DNATTarget)(nil))
	state.Register((*RedirectTarget)(nil))
	state.Register((*SNATTarget)(nil))
	state.Register((*MasqueradeTarget)(nil))
	state.Register((*IPTables)(nil))
	state.Register((*Table)(nil))
	state.Register((*Rule)(nil))
	state.Register((*IPHeaderFilter)(nil))
	state.Register((*dynamicCacheEntry)(nil))
	state.Register((*neighborCacheMu)(nil))
	state.Register((*neighborCache)(nil))
	state.Register((*NeighborEntry)(nil))
	state.Register((*timer)(nil))
	state.Register((*neighborEntryMu)(nil))
	state.Register((*neighborEntry)(nil))
	state.Register((*neighborEntryList)(nil))
	state.Register((*neighborEntryEntry)(nil))
	state.Register((*linkResolver)(nil))
	state.Register((*nic)(nil))
	state.Register((*packetEndpointList)(nil))
	state.Register((*delegatingQueueingDiscipline)(nil))
	state.Register((*sharedStats)(nil))
	state.Register((*multiCounterNICPacketStats)(nil))
	state.Register((*multiCounterNICNeighborStats)(nil))
	state.Register((*multiCounterNICStats)(nil))
	state.Register((*NUDConfigurations)(nil))
	state.Register((*nudStateMu)(nil))
	state.Register((*NUDState)(nil))
	state.Register((*PacketBuffer)(nil))
	state.Register((*headerInfo)(nil))
	state.Register((*PacketData)(nil))
	state.Register((*PacketBufferList)(nil))
	state.Register((*packetBufferRefs)(nil))
	state.Register((*pendingPacket)(nil))
	state.Register((*packetsPendingLinkResolution)(nil))
	state.Register((*TransportEndpointID)(nil))
	state.Register((*NetworkPacketInfo)(nil))
	state.Register((*PacketMMapOpts)(nil))
	state.Register((*AddressLifetimes)(nil))
	state.Register((*UnicastSourceAndMulticastDestination)(nil))
	state.Register((*DADConfigurations)(nil))
	state.Register((*GSOType)(nil))
	state.Register((*GSO)(nil))
	state.Register((*routeInfo)(nil))
	state.Register((*RouteInfo)(nil))
	state.Register((*transportProtocolState)(nil))
	state.Register((*Stack)(nil))
	state.Register((*TransportEndpointInfo)(nil))
	state.Register((*protocolIDs)(nil))
	state.Register((*transportEndpoints)(nil))
	state.Register((*endpointsByNIC)(nil))
	state.Register((*transportDemuxer)(nil))
	state.Register((*multiPortEndpoint)(nil))
	state.Register((*tupleList)(nil))
	state.Register((*tupleEntry)(nil))
}
