# How to Activate the Amazon Q Business Web Experience

## Issue: Web Experience showing 404

The web experience is in `PENDING_AUTH_CONFIG` status and needs to be activated via AWS Console.

## Solution: Activate via AWS Console

### Step 1: Go to Amazon Q Business Console
1. Open AWS Console
2. Navigate to: **Amazon Q Business** service
3. Region: **us-west-2** (Oregon)

### Step 2: Select Your Application
1. Find and click: **my-qbusiness-app**
2. Application ID: `8ea6e006-85cc-47bd-a587-b14bff19884d`

### Step 3: Configure Web Experience
1. In the left sidebar, click **Web experience**
2. You should see your web experience with status `PENDING_AUTH_CONFIG`
3. Click on the web experience or click **Edit**
4. Follow the wizard to complete authentication configuration

### Step 4: Configure Authentication
The console will guide you through:
1. Confirming IAM Identity Center integration
2. Setting up user access
3. Configuring authentication method (usually automatic with IAM Identity Center)
4. Click **Activate** or **Deploy**

### Step 5: Wait for Activation
- Status will change from `PENDING_AUTH_CONFIG` to `ACTIVE`
- This usually takes 2-5 minutes
- The URL will then be accessible

---

## Alternative: Use AWS Console Link Directly

Open this URL in your browser:
```
https://us-west-2.console.aws.amazon.com/amazonq/home?region=us-west-2#applications/8ea6e006-85cc-47bd-a587-b14bff19884d
```

Then navigate to **Web experience** in the left menu.

---

## Alternative Testing Method: Use the API

While waiting for web experience activation, you can test Q Business via API:

### Test Query via CLI
```bash
aws qbusiness chat-sync \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --user-id qbusiness-admin \
  --user-message "What is our remote work policy?" \
  --region us-west-2
```

Note: This requires proper IAM permissions for the user/role running the command.

---

## Expected Timeline

1. **AWS Console Configuration:** 5-10 minutes
2. **Web Experience Activation:** 2-5 minutes
3. **Document Indexing:** 5-15 minutes (already in progress)

Total time to full functionality: ~15-30 minutes

---

## Verification Steps

After activation via console:

### Check Status
```bash
aws qbusiness get-web-experience \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --web-experience-id 48e43dde-1857-4256-9c79-a71bb6b2b0a0 \
  --region us-west-2 | jq '.status'
```

Expected output: `"ACTIVE"`

### Access Web Experience
URL: https://jcfskw7s.chat.qbusiness.us-west-2.on.aws/

Should show login page instead of 404.

---

## Troubleshooting

### Still Getting 404 After Activation
1. Wait 5 minutes and try again (DNS propagation)
2. Clear browser cache
3. Try incognito/private browsing mode
4. Check that status is truly `ACTIVE`

### Cannot Find Application in Console
1. Verify you're in the correct region: **us-west-2**
2. Search for "Amazon Q Business" in AWS Console search bar
3. Use the direct link provided above

### Authentication Issues
1. Ensure IAM Identity Center is active
2. Verify user password is set for qbusiness-admin
3. Check that auto-subscription is enabled (already done)

---

## Why Console Activation is Required

Amazon Q Business web experiences require console activation for security reasons:
- Finalizes authentication configuration
- Sets up secure session handling
- Configures CORS and security policies
- Validates IAM Identity Center integration

This is a one-time setup step that cannot be fully automated via CLI.

