# Fix 403 Forbidden Error - Amazon Q Business Web Experience

## Problem
You're getting a 403 Forbidden error when accessing the Q Business web experience at:
https://y5h1aq8x.chat.qbusiness.us-west-2.on.aws/

## Root Cause
The Q Business application is deployed and active, but **no users have been granted access** through IAM Identity Center. The application requires explicit user assignments.

## Current Status
- Application ID: `3c7d9269-6a04-4657-9899-09d630e7176f`
- Web Experience ID: `08b1654c-78a8-43b2-b31f-734456b45e06`
- Status: ACTIVE
- Region: us-west-2
- Identity Center Application: `arn:aws:sso::460783431756:application/ssoins-6508577ae76ccfc0/apl-6658c1efa85d23f2`

## Solution: Grant User Access via AWS Console

### Step 1: Access IAM Identity Center Console

1. Go to the AWS Console
2. Navigate to **IAM Identity Center** (search for it in the services search bar)
3. Or go directly to: https://console.aws.amazon.com/singlesignon

### Step 2: Create or Verify Users

1. In IAM Identity Center, click **Users** in the left sidebar
2. If you don't have any users, click **Add user**:
   - Username: `qbusiness-user` (or your preferred username)
   - Email: Your email address
   - First name and Last name
   - Click **Next**
   - Optionally add to groups
   - Click **Add user**
3. If creating a new user, check your email for the invitation and set up your password

### Step 3: Assign Users to Q Business Application

#### Option A: Through IAM Identity Center Console

1. In IAM Identity Center, go to **Applications** → **AWS Account applications**
2. Look for the Q Business application (it might be named "Amazon Q Business" or "my-qbusiness-app")
3. Click on the application
4. Click **Assign users and groups**
5. Select the user(s) you want to grant access to
6. Click **Assign users**

#### Option B: Through Amazon Q Business Console

1. Go to the AWS Console
2. Navigate to **Amazon Q Business**
3. Click on your application: `my-qbusiness-app`
4. Click the **Access management** tab
5. Click **Add users and groups**
6. Select users from Identity Center
7. Choose subscription tier:
   - **Q Business Lite** ($3/user/month) - Basic features
   - **Q Business Pro** ($20/user/month) - Advanced features
8. Click **Assign**

### Step 4: Wait for Propagation (1-5 minutes)

After assigning users, wait a few minutes for the changes to propagate.

### Step 5: Test Access

1. Open the web experience URL: https://y5h1aq8x.chat.qbusiness.us-west-2.on.aws/
2. You should be redirected to sign in with your Identity Center credentials
3. Sign in with the user you assigned access to
4. You should now see the Q Business chat interface

## Alternative: Use AWS CLI (if you have the correct Identity Store ID)

If you can find your Identity Store ID, you can use the CLI:

```bash
# Get Identity Center instance details
aws sso-admin list-instances --region us-west-2

# Once you have the IdentityStoreId, list users
IDENTITY_STORE_ID="<your-identity-store-id>"
aws identitystore list-users --identity-store-id $IDENTITY_STORE_ID --region us-west-2

# Create a user (if needed)
aws identitystore create-user \
  --identity-store-id $IDENTITY_STORE_ID \
  --user-name "qbusiness-user" \
  --display-name "Q Business User" \
  --name Formatted="Q Business User",FamilyName="User",GivenName="Q Business" \
  --emails Value="your-email@example.com",Primary=true \
  --region us-west-2
```

**Note**: The Identity Store ID is different from what's in the SSO instance ARN. It must be retrieved from the `aws sso-admin list-instances` command.

## Verification Commands

### Check Application Status
```bash
aws qbusiness get-application \
  --application-id 3c7d9269-6a04-4657-9899-09d630e7176f \
  --region us-west-2
```

### Check Web Experience Status
```bash
aws qbusiness get-web-experience \
  --application-id 3c7d9269-6a04-4657-9899-09d630e7176f \
  --web-experience-id 08b1654c-78a8-43b2-b31f-734456b45e06 \
  --region us-west-2
```

### Check if User Has Access (after assignment)
Once you have access, you can test with the chat scripts:
```bash
# Test with simple chat
./chat-simple.sh "Hello, what can you help me with?"

# Or use interactive mode
./qbusiness-interactive.sh
```

## Common Issues

### Issue 1: "No users found in Identity Center"
**Solution**: Create users through the IAM Identity Center console (see Step 2 above)

### Issue 2: "Cannot access Identity Center settings"
**Solution**: Ensure you're logged in as an administrator or have the necessary IAM permissions:
- `sso:*`
- `sso-admin:*`
- `identitystore:*`
- `qbusiness:*`

### Issue 3: "Still getting 403 after assigning users"
**Solutions**:
1. Wait 5-10 minutes for propagation
2. Clear your browser cache and cookies
3. Try an incognito/private browser window
4. Verify the user assignment in the Q Business console
5. Check that the user's subscription tier is active

### Issue 4: "Identity Center not showing Q Business application"
**Solution**: The application might be in the **Customer managed applications** section rather than **AWS Account applications**

## Why This Happened

Amazon Q Business uses IAM Identity Center for authentication and authorization. Even though the application is deployed and active:

1. The infrastructure (app, index, web experience) is created ✓
2. IAM roles and permissions are configured ✓
3. **BUT** - No users are automatically granted access ✗

This is a security-by-default approach - you must explicitly assign users.

## Next Steps After Granting Access

Once you have access working:

1. **Add data sources** to populate the knowledge base:
   ```bash
   # Upload documents to S3 and configure as data source
   aws qbusiness create-data-source ...
   ```

2. **Test the chat functionality**:
   ```bash
   ./chat-simple.sh "What documents are available?"
   ```

3. **Invite more users** through the same process above

4. **Configure additional settings**:
   - Sample prompts
   - Customization (logo, colors)
   - Browser extensions
   - Security settings

## Support Resources

- **IAM Identity Center Guide**: https://docs.aws.amazon.com/singlesignon/latest/userguide/
- **Amazon Q Business Access Management**: https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/access-management.html
- **Subscription Tiers**: https://aws.amazon.com/q/business/pricing/

---

**Quick Summary**: You need to go to the AWS Console → IAM Identity Center → Create/select a user → Assign that user to the Q Business application. The CLI can't easily do this because Identity Center management is primarily console-based.
