# 授予 Amazon Q Business 访问权限 - 完整步骤

## 当前状态

### Identity Center 信息
- **实例名称**: iam_claude
- **区域**: eu-north-1 (欧洲-斯德哥尔摩)
- **Identity Store ID**: d-c367615483
- **组织 ID**: o-g1v5dy48ik

### 现有用户
- **用户名**: qbusiness-admin
- **用户 ID**: 108cc92c-b0a1-7073-1ac0-b153f32f9e6c
- **邮箱**: yan9.yue@yandex.com
- **显示名称**: Q Business Admin

### Q Business 应用信息
- **应用 ID**: 3c7d9269-6a04-4657-9899-09d630e7176f
- **区域**: us-west-2
- **Web 体验 URL**: https://y5h1aq8x.chat.qbusiness.us-west-2.on.aws/
- **状态**: ACTIVE

## 解决 403 错误的步骤

### 方法 1: 通过 AWS 控制台（推荐 - 最简单）

#### 第 1 步: 访问 Amazon Q Business 控制台

1. 登录 AWS 控制台
2. 在服务搜索栏中输入 "Amazon Q Business"
3. 或直接访问: https://us-west-2.console.aws.amazon.com/amazonq/business

#### 第 2 步: 选择您的应用

1. 确保您在 **us-west-2** 区域（右上角区域选择器）
2. 找到并点击应用: **my-qbusiness-app**
3. 应用 ID 应该是: `3c7d9269-6a04-4657-9899-09d630e7176f`

#### 第 3 步: 管理用户访问

1. 在应用详情页面，点击 **"访问管理"** 或 **"Access management"** 标签
2. 点击 **"添加用户和组"** 或 **"Add users and groups"** 按钮
3. 选择用户:
   - 找到 **qbusiness-admin** (yan9.yue@yandex.com)
   - 勾选该用户
4. 选择订阅层级:
   - **Q Business Lite**: $3/用户/月 - 基础功能
   - **Q Business Pro**: $20/用户/月 - 高级功能
5. 点击 **"分配"** 或 **"Assign"**

#### 第 4 步: 等待生效

- 等待 2-5 分钟，让权限传播生效

#### 第 5 步: 测试访问

1. 打开新的浏览器标签页（或无痕模式）
2. 访问: https://y5h1aq8x.chat.qbusiness.us-west-2.on.aws/
3. 使用 Identity Center 凭据登录:
   - 用户名: `qbusiness-admin`
   - 密码: （您在 Identity Center 中设置的密码）
4. 现在应该能看到 Q Business 聊天界面了！

---

### 方法 2: 通过 IAM Identity Center 控制台

#### 第 1 步: 访问 IAM Identity Center

1. 登录 AWS 控制台
2. 搜索 "IAM Identity Center"
3. 或直接访问: https://eu-north-1.console.aws.amazon.com/singlesignon

#### 第 2 步: 查看应用

1. 在左侧菜单中，点击 **"应用程序"** 或 **"Applications"**
2. 查找 Amazon Q Business 相关的应用
   - 可能显示为 "Amazon Q Business"
   - 或者在 **"客户管理的应用程序"** 部分

#### 第 3 步: 分配用户

1. 点击 Q Business 应用
2. 点击 **"分配用户"** 或 **"Assign users"**
3. 选择 **qbusiness-admin**
4. 点击 **"分配用户"**

---

### 方法 3: 使用 AWS CLI（高级）

**注意**: Q Business 的用户分配主要通过控制台管理。CLI 方法可能不完整。

```bash
# 设置变量
APP_ID="3c7d9269-6a04-4657-9899-09d630e7176f"
USER_ID="108cc92c-b0a1-7073-1ac0-b153f32f9e6c"
IDENTITY_STORE_ID="d-c367615483"
REGION="us-west-2"

# 验证用户信息
aws identitystore get-user \
  --identity-store-id $IDENTITY_STORE_ID \
  --user-id $USER_ID \
  --region eu-north-1

# 注意: Q Business 用户分配需要通过控制台完成
# 下面的命令可能不可用或需要额外的权限
```

---

## 验证访问是否成功

### 1. 通过 Web 界面

访问 https://y5h1aq8x.chat.qbusiness.us-west-2.on.aws/ 应该能够：
- 看到登录页面（不是 403 错误）
- 成功登录
- 看到聊天界面

### 2. 通过 CLI 测试

```bash
# 测试聊天功能
./chat-simple.sh "Hello, what can you help me with?"

# 或使用交互式会话
./qbusiness-interactive.sh
```

**注意**: 脚本中已经硬编码了正确的用户 ID：
- USER_ID: `108cc92c-b0a1-7073-1ac0-b153f32f9e6c`
- APP_ID: `3c7d9269-6a04-4657-9899-09d630e7176f`

### 3. 验证分配状态

访问 Q Business 控制台检查:
```
https://us-west-2.console.aws.amazon.com/amazonq/business/applications/3c7d9269-6a04-4657-9899-09d630e7176f
```

在 **"Access management"** 标签下应该能看到 `qbusiness-admin` 用户已被分配。

---

## 常见问题

### Q: 我忘记了 Identity Center 密码
**A**:
1. 去 IAM Identity Center 控制台
2. 用户 → qbusiness-admin
3. 点击 "重置密码" 或 "Send password reset email"
4. 检查邮箱: yan9.yue@yandex.com

### Q: 仍然看到 403 错误
**A**:
1. 确认用户已在 Q Business 应用中分配（方法 1 第 3 步）
2. 等待 5-10 分钟
3. 清除浏览器缓存和 cookies
4. 尝试无痕/隐私浏览模式
5. 确认您登录的用户是 `qbusiness-admin`

### Q: 找不到 Q Business 应用
**A**:
1. 确保在正确的区域: **us-west-2**
2. 在 Q Business 控制台搜索应用 ID: `3c7d9269-6a04-4657-9899-09d630e7176f`
3. 应用名称是: `my-qbusiness-app`

### Q: Identity Center 在不同区域，会有问题吗？
**A**:
不会！IAM Identity Center 是全局服务，虽然实例在 eu-north-1，但可以为 us-west-2 的 Q Business 应用提供认证。这是正常配置。

---

## 下一步

成功访问后，您可以：

### 1. 添加数据源

上传文档到 S3 并配置为数据源，这样 Q Business 才能回答基于您文档的问题。

### 2. 测试聊天功能

```bash
# 简单测试
./chat-simple.sh "Hello!"

# 交互式对话
./qbusiness-interactive.sh
```

### 3. 添加更多用户

重复上述步骤，为其他团队成员创建用户并分配访问权限。

### 4. 配置自定义设置

- 自定义 logo 和颜色
- 启用示例提示
- 配置浏览器扩展
- 设置安全策略

---

## 快速总结

**问题**: 403 Forbidden 错误
**原因**: 用户 `qbusiness-admin` 存在，但未被分配到 Q Business 应用
**解决方案**:
1. 去 AWS 控制台 → Amazon Q Business (us-west-2)
2. 选择应用 `my-qbusiness-app`
3. Access management → Add users → 选择 `qbusiness-admin` → Assign
4. 等待 2-5 分钟
5. 重新访问 Web URL

**最简单的方法**: 使用控制台完成用户分配（方法 1）
