# Amazon Q Business - 快速开始指南

## 🚀 三种方式启动聊天会话

---

## 方式 1: 使用简单脚本（最快）

```bash
./chat-simple.sh 'What is our remote work policy?'
```

**优点：**
- ✅ 最简单快速
- ✅ 一行命令完成
- ✅ 自动显示回复和引用文档

**示例：**
```bash
# 询问公司政策
./chat-simple.sh 'What is our remote work policy?'

# 询问福利
./chat-simple.sh 'How many vacation days do I get?'

# 询问产品
./chat-simple.sh 'What is CloudSync Pro?'
```

---

## 方式 2: 交互式会话（推荐日常使用）

```bash
./qbusiness-interactive.sh
```

**优点：**
- ✅ 支持多轮对话
- ✅ 保持会话上下文
- ✅ 彩色输出，易于阅读
- ✅ 显示引用的源文档

**使用示例：**
```
You: What is our remote work policy?
Q Business: Based on our company policy...

You: What equipment do we provide?
Q Business: According to the policy...

You: exit
```

**可用命令：**
- `help` - 显示帮助
- `clear` - 清空会话历史
- `status` - 查看当前状态
- `exit` 或 `quit` - 退出

---

## 方式 3: 纯 Terraform 方式（适合自动化）

### 3.1 使用配置文件

编辑 `terraform-chat.tfvars`：
```hcl
enable_chat_session = true
chat_user_message = "What is our remote work policy?"
chat_user_id = "108cc92c-b0a1-7073-1ac0-b153f32f9e6c"
```

运行：
```bash
terraform apply -var-file="terraform-chat.tfvars" -auto-approve
```

### 3.2 命令行直接指定

```bash
terraform apply \
  -var="enable_chat_session=true" \
  -var='chat_user_message=What is our remote work policy?' \
  -auto-approve
```

### 3.3 查看 Terraform 输出

```bash
# 查看完整响应
cat /tmp/qbusiness-chat-response.json | jq

# 仅查看回复内容
cat /tmp/qbusiness-chat-response.json | jq -r '.systemMessage'

# 查看会话 ID（用于后续对话）
cat /tmp/qbusiness-conversation-id.txt
```

---

## 📋 常用问题示例

### 关于公司政策
```bash
./chat-simple.sh 'What is our remote work policy?'
./chat-simple.sh 'What equipment does the company provide for remote workers?'
./chat-simple.sh 'What are the core working hours?'
```

### 关于员工福利
```bash
./chat-simple.sh 'How many vacation days do I get?'
./chat-simple.sh 'What is the company 401k match?'
./chat-simple.sh 'Tell me about parental leave'
```

### 关于产品
```bash
./chat-simple.sh 'What is CloudSync Pro?'
./chat-simple.sh 'What are the pricing tiers?'
./chat-simple.sh 'What integrations are available?'
```

---

## 🔄 多轮对话示例

### 使用 AWS CLI

```bash
# 第一个问题
response=$(aws qbusiness chat-sync \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --user-id 108cc92c-b0a1-7073-1ac0-b153f32f9e6c \
  --user-message "What is CloudSync Pro?" \
  --region us-west-2)

echo "$response" | jq -r '.systemMessage'

# 获取会话 ID
CONV_ID=$(echo "$response" | jq -r '.conversationId')

# 继续对话
aws qbusiness chat-sync \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --user-id 108cc92c-b0a1-7073-1ac0-b153f32f9e6c \
  --conversation-id $CONV_ID \
  --user-message "What are the pricing tiers?" \
  --region us-west-2 | jq -r '.systemMessage'
```

---

## 📊 当前部署信息

| 资源 | 值 |
|------|-----|
| **Application ID** | `8ea6e006-85cc-47bd-a587-b14bff19884d` |
| **User ID** | `108cc92c-b0a1-7073-1ac0-b153f32f9e6c` |
| **Region** | `us-west-2` |
| **Web URL** | https://jcfskw7s.chat.qbusiness.us-west-2.on.aws/ |
| **S3 Bucket** | `qbusiness-datasource-1761451657` |
| **Index ID** | `7ce939ab-cbeb-4f20-9626-be32313723bc` |

---

## 🛠️ 可用的文档内容

您的 Q Business 已索引以下文档：

1. **company-policy.txt** - 公司远程工作政策
2. **employee-handbook.txt** - 员工手册（福利、假期等）
3. **product-faq.txt** - CloudSync Pro 产品 FAQ

---

## 📁 相关文件

| 文件 | 说明 |
|------|------|
| `chat-simple.sh` | 简单聊天脚本 |
| `qbusiness-interactive.sh` | 交互式聊天会话 |
| `qbusiness-chat-session.tf` | Terraform 聊天配置 |
| `terraform-chat.tfvars` | Terraform 变量文件 |
| `TERRAFORM_CHAT_GUIDE.md` | Terraform 详细指南 |
| `/tmp/qbusiness-chat-response.json` | 最新响应 |
| `/tmp/qbusiness-conversation-id.txt` | 会话 ID |

---

## 🔧 故障排查

### 问题：没有响应

**检查应用状态：**
```bash
aws qbusiness get-application \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --region us-west-2
```

### 问题：文档未索引

**检查索引状态：**
```bash
aws qbusiness get-index \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --index-id 7ce939ab-cbeb-4f20-9626-be32313723bc \
  --region us-west-2 | jq '.indexStatistics'
```

### 问题：认证错误

**验证用户：**
```bash
aws identitystore get-user \
  --identity-store-id d-9067e46e40 \
  --user-id 108cc92c-b0a1-7073-1ac0-b153f32f9e6c \
  --region us-west-2
```

---

## 💡 最佳实践

1. **日常使用** → 使用 `qbusiness-interactive.sh`
2. **快速查询** → 使用 `chat-simple.sh`
3. **自动化/CI/CD** → 使用 Terraform 方式
4. **Web 界面** → 访问 Web Experience URL

---

## 🎯 下一步

1. ✅ 尝试运行 `./chat-simple.sh 'What is our remote work policy?'`
2. ✅ 使用 `./qbusiness-interactive.sh` 进行多轮对话
3. ✅ 上传更多文档到 S3 bucket
4. ✅ 配置更多 IAM Identity Center 用户
5. ✅ 探索 Terraform 自动化选项

---

**提示：** 开始最简单的方式就是运行：

```bash
./chat-simple.sh 'Hello, what can you help me with?'
```
