# Amazon Q Business Terraform Deployment

This Terraform configuration deploys Amazon Q Business with the following components:

## Resources Created

1. **Amazon Q Business Application** - The main Q Business application
2. **Index** - Enterprise index for document storage and retrieval
3. **Web Experience** - Chat interface for users
4. **IAM Roles and Policies** - Required permissions for the application

## Important Notes

- **AWS Provider Limitation**: The AWS Terraform provider doesn't yet have native support for Amazon Q Business resources
- **Hybrid Approach**: This configuration uses Terraform for IAM resources and AWS CLI (via `null_resource`) for Amazon Q Business resources
- **IAM Identity Center Required**: You must have AWS IAM Identity Center enabled in your account

## Prerequisites

- AWS CLI configured with valid credentials
- Terraform >= 1.0
- `jq` installed (JSON processor)
- AWS IAM Identity Center enabled in your account
- AWS account with permissions to create Q Business resources

## Setup Instructions

### 1. Get your IAM Identity Center Instance ARN

Run the helper script to find your Identity Center instance ARN:

```bash
./get-identity-center-arn.sh
```

If you don't have Identity Center enabled:
1. Go to AWS Console → IAM Identity Center
2. Enable IAM Identity Center
3. Run the script again to get the ARN

### 2. Configure your deployment

Edit `terraform.tfvars` and add your Identity Center ARN:

```hcl
identity_center_instance_arn = "arn:aws:sso:::instance/ssoins-xxxxxxxxx"
application_name             = "my-qbusiness-app"
aws_region                  = "eu-central-1"
```

### 3. Initialize Terraform

```bash
terraform init
```

### 4. Review the execution plan

```bash
terraform plan
```

### 5. Deploy the infrastructure

```bash
terraform apply
```

Type `yes` when prompted to confirm.

### 6. Access your deployment

After successful deployment:
- View application details: `cat /tmp/qbusiness-app.json`
- View index details: `cat /tmp/qbusiness-index.json`
- View web experience details: `cat /tmp/qbusiness-web-experience.json`
- Get web URL: `jq -r '.webExperienceArn' /tmp/qbusiness-web-experience.json`

## Configuration Options

### Enable S3 Data Source

To connect an S3 bucket as a data source:

1. Set `create_s3_datasource = true` in `terraform.tfvars`
2. Specify your bucket name: `data_source_bucket = "your-bucket-name"`
3. Ensure the bucket exists in the same region

### Adjust Index Capacity

Modify `index_capacity_units` based on your needs:
- 1 unit = suitable for testing/small deployments
- Increase for production workloads

## Outputs

- `application_id` - Use this to interact with the Q Business API
- `web_experience_url` - Share this URL with users to access the chat interface
- `index_id` - Reference for data source configurations

## Clean Up

To destroy all resources:

```bash
terraform destroy
```

## Important Notes

1. Amazon Q Business is available in limited AWS regions
2. Check pricing before deploying: https://aws.amazon.com/q/business/pricing/
3. Web experience requires user authentication setup
4. Data sources need proper IAM permissions to access content

## Troubleshooting

### Authentication Issues
Ensure your AWS credentials have permissions for:
- `qbusiness:*`
- `iam:CreateRole`
- `iam:CreatePolicy`

### Region Availability
If you get region errors, verify Q Business is available in your region.

## Next Steps

After deployment:
1. Configure user access via AWS IAM Identity Center
2. Set up data sources (S3, SharePoint, etc.)
3. Configure retrieval settings
4. Test the web experience
