#!/bin/bash
# 简单的 Terraform 聊天会话启动脚本

APP_ID="8ea6e006-85cc-47bd-a587-b14bff19884d"
USER_ID="108cc92c-b0a1-7073-1ac0-b153f32f9e6c"
REGION="us-west-2"

# 检查参数
if [ -z "$1" ]; then
    echo "用法: $0 '你的问题'"
    echo ""
    echo "示例:"
    echo "  $0 'What is our remote work policy?'"
    echo "  $0 'How many vacation days do I get?'"
    echo "  $0 'What is CloudSync Pro?'"
    exit 1
fi

QUESTION="$1"

echo "========================================"
echo "发送问题到 Amazon Q Business..."
echo "========================================"
echo "问题: $QUESTION"
echo ""

# 使用 Terraform 变量方式启动会话
terraform apply \
  -var="enable_chat_session=true" \
  -var="chat_user_message=$QUESTION" \
  -var="chat_user_id=$USER_ID" \
  -auto-approve \
  -compact-warnings 2>&1 | grep -A 50 "Q Business Response:" || {
    echo "使用直接 AWS CLI 方式..."
    echo ""

    # 备用方案：直接使用 AWS CLI
    response=$(aws qbusiness chat-sync \
      --application-id $APP_ID \
      --user-id $USER_ID \
      --user-message "$QUESTION" \
      --region $REGION 2>&1)

    if [ $? -eq 0 ]; then
        echo "Q Business 回复:"
        echo "========================================"
        echo "$response" | jq -r '.systemMessage'
        echo ""

        # 保存会话信息
        echo "$response" > /tmp/qbusiness-chat-response.json
        echo "$response" | jq -r '.conversationId' > /tmp/qbusiness-conversation-id.txt

        # 显示引用文档
        sources=$(echo "$response" | jq -r '.sourceAttributions[]?.title // empty' 2>/dev/null)
        if [ -n "$sources" ]; then
            echo ""
            echo "参考文档:"
            echo "$response" | jq -r '.sourceAttributions[] | "  - \(.title)"'
        fi

        echo "========================================"
    else
        echo "错误: 无法连接到 Q Business"
        echo "$response"
        exit 1
    fi
}
