#!/bin/bash

set -e

echo "==========================================="
echo "Enabling AWS IAM Identity Center"
echo "==========================================="
echo ""

# IAM Identity Center must be enabled through the AWS Console for the first time
# This is a limitation of AWS - it cannot be done via CLI/API on first setup

echo "Unfortunately, AWS IAM Identity Center MUST be enabled through the AWS Console"
echo "for the initial setup. The AWS CLI/API does not support enabling it programmatically."
echo ""
echo "Please follow these steps:"
echo ""
echo "1. Open your web browser and go to:"
echo "   https://console.aws.amazon.com/singlesignon/home?region=us-east-1#/"
echo ""
echo "2. Sign in with your AWS credentials:"
echo "   Account: 460783431756"
echo "   Root email: zishadeng@gmail.com"
echo ""
echo "3. Click the 'Enable' button"
echo ""
echo "4. Choose 'Enable with AWS Organizations'"
echo "   (Organizations has already been created: o-g1v5dy48ik)"
echo ""
echo "5. Choose your identity source:"
echo "   - Recommended: 'Identity Center directory' (AWS managed)"
echo "   - Alternative: Active Directory or External IdP"
echo ""
echo "6. Complete the wizard (should take 1-2 minutes)"
echo ""
echo "7. After enabling, run this command to verify:"
echo "   ./get-identity-center-arn.sh"
echo ""
echo "8. Then proceed with deployment:"
echo "   ./deploy.sh"
echo ""
echo "==========================================="
echo ""
echo "Why manual setup is required:"
echo "- Identity Center requires one-time consent in the Console"
echo "- AWS restricts programmatic access for initial setup"
echo "- This is a security feature from AWS"
echo ""
echo "This is a one-time setup. Once enabled, you can manage it via CLI/Terraform."
echo ""
