#!/bin/bash

# Script to retrieve AWS IAM Identity Center instance ARN
# This is required for Amazon Q Business deployment

echo "Checking for IAM Identity Center instances..."

INSTANCE=$(aws sso-admin list-instances --output json 2>/dev/null)

if [ $? -ne 0 ]; then
    echo "Error: Failed to list IAM Identity Center instances."
    echo "Make sure you have the necessary permissions and that Identity Center is enabled in your AWS account."
    exit 1
fi

INSTANCE_ARN=$(echo "$INSTANCE" | jq -r '.Instances[0].InstanceArn // empty')

if [ -z "$INSTANCE_ARN" ]; then
    echo "No IAM Identity Center instance found."
    echo ""
    echo "You need to set up AWS IAM Identity Center first:"
    echo "1. Go to AWS Console"
    echo "2. Navigate to IAM Identity Center"
    echo "3. Enable IAM Identity Center"
    echo "4. After setup, run this script again"
    exit 1
else
    echo "Found IAM Identity Center instance:"
    echo "$INSTANCE_ARN"
    echo ""
    echo "Add this to your terraform.tfvars file:"
    echo "identity_center_instance_arn = \"$INSTANCE_ARN\""
fi
