#!/bin/bash
# AWS SSO Login Helper for Amazon Q Business
# SSO 登录辅助脚本

PROFILE="qbusiness-sso"

# 颜色定义
GREEN='\033[0;32m'
BLUE='\033[0;34m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m' # No Color

echo -e "${GREEN}======================================${NC}"
echo -e "${GREEN}AWS SSO 登录助手${NC}"
echo -e "${GREEN}======================================${NC}"
echo ""

# 检查当前登录状态
echo -e "${BLUE}检查当前 SSO 登录状态...${NC}"
if aws sts get-caller-identity --profile $PROFILE &>/dev/null; then
    echo -e "${GREEN}✓ 您已经登录！${NC}"
    echo ""

    # 显示当前身份信息
    identity=$(aws sts get-caller-identity --profile $PROFILE 2>/dev/null)
    echo -e "${YELLOW}当前身份信息:${NC}"
    echo "$identity" | jq .
    echo ""

    echo -e "${YELLOW}如需重新登录，请运行:${NC}"
    echo "  aws sso login --profile $PROFILE"
    exit 0
fi

echo -e "${YELLOW}未登录。开始 SSO 登录流程...${NC}"
echo ""

echo -e "${BLUE}SSO 配置信息:${NC}"
echo "  Profile: $PROFILE"
echo "  Start URL: https://d-c367615483.awsapps.com/start"
echo "  Region: eu-north-1"
echo "  Account: 460783431756"
echo ""

echo -e "${YELLOW}方法 1: 自动登录 (推荐)${NC}"
echo "运行以下命令将打开浏览器进行登录:"
echo -e "${GREEN}aws sso login --profile $PROFILE${NC}"
echo ""

echo -e "${YELLOW}方法 2: 手动登录${NC}"
echo "1. 在浏览器中访问: https://d-c367615483.awsapps.com/start"
echo "2. 使用您的 Identity Center 用户凭证登录"
echo "3. 选择账户: 460783431756"
echo "4. 选择权限集: AdministratorAccess"
echo ""

read -p "是否现在尝试自动登录? (y/n): " -n 1 -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
    echo ""
    echo -e "${BLUE}启动 SSO 登录...${NC}"
    aws sso login --profile $PROFILE

    if [ $? -eq 0 ]; then
        echo ""
        echo -e "${GREEN}✓ 登录成功！${NC}"
        echo ""

        # 验证登录
        if aws sts get-caller-identity --profile $PROFILE &>/dev/null; then
            echo -e "${GREEN}已验证身份:${NC}"
            aws sts get-caller-identity --profile $PROFILE | jq .
            echo ""
            echo -e "${GREEN}您现在可以使用以下脚本与 Amazon Q Business 对话:${NC}"
            echo "  ./chat-with-sso.sh 'Your question'"
            echo "  ./chat-interactive-sso.sh"
        fi
    else
        echo ""
        echo -e "${RED}登录失败。请手动登录。${NC}"
    fi
else
    echo ""
    echo -e "${YELLOW}取消自动登录。请按照上述方法 2 手动登录。${NC}"
fi
