# Amazon Q Business Deployment Summary

## Deployment Status: ✅ COMPLETE

Deployment Date: 2025-10-25
Region: us-west-2

---

## Created Resources

### Application
- **Name:** my-qbusiness-app
- **Application ID:** 8ea6e006-85cc-47bd-a587-b14bff19884d
- **Status:** ACTIVE
- **ARN:** arn:aws:qbusiness:us-west-2:460783431756:application/8ea6e006-85cc-47bd-a587-b14bff19884d
- **Identity Type:** AWS_IAM_IDC
- **Auto-Subscription:** ENABLED (Q_BUSINESS)

### Index
- **Name:** my-qbusiness-app-index
- **Index ID:** 7ce939ab-cbeb-4f20-9626-be32313723bc
- **Type:** ENTERPRISE
- **Status:** ACTIVE
- **Capacity:** 1 unit

### Retriever
- **Name:** main-retriever
- **Retriever ID:** a1ce06c6-82a7-46f1-be41-4d7ab30bafd9
- **Type:** NATIVE_INDEX
- **Connected Index:** 7ce939ab-cbeb-4f20-9626-be32313723bc

### Web Experience
- **Title:** my-qbusiness-app
- **Web Experience ID:** 48e43dde-1857-4256-9c79-a71bb6b2b0a0
- **URL:** https://jcfskw7s.chat.qbusiness.us-west-2.on.aws/
- **Status:** PENDING_AUTH_CONFIG
- **Subtitle:** Your AI-powered business assistant

### IAM Role
- **Role Name:** my-qbusiness-app-app-role
- **ARN:** arn:aws:iam::460783431756:role/my-qbusiness-app-app-role
- **Service:** qbusiness.amazonaws.com

---

## IAM Identity Center Configuration

### Instance Details
- **Instance ARN:** arn:aws:sso:::instance/ssoins-6508577ae76ccfc0
- **Instance ID:** ssoins-6508577ae76ccfc0
- **Identity Store ID:** d-c367615483
- **Region:** eu-north-1
- **Status:** ACTIVE
- **Name:** iam_claude

### Users Created
1. **qbusiness-admin**
   - User ID: 108cc92c-b0a1-7073-1ac0-b153f32f9e6c
   - Display Name: Q Business Admin
   - Email: admin@example.com
   - Account Assignment: ENABLED

---

## Access Information

### Web Experience URL
```
https://jcfskw7s.chat.qbusiness.us-west-2.on.aws/
```

### Login Instructions
1. Navigate to the web experience URL above
2. Sign in using IAM Identity Center credentials
3. Use the username: `qbusiness-admin`
4. Set up password via IAM Identity Center console or password reset email

---

## Next Steps

### 1. Configure User Authentication
The web experience is currently in `PENDING_AUTH_CONFIG` status. To activate it:
- Complete SAML/OIDC configuration in IAM Identity Center
- Or use the AWS Console to finalize authentication settings

### 2. Add Data Sources
Currently no data sources are configured. To add data:

**Option A: S3 Data Source**
```bash
aws qbusiness create-data-source \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --index-id 7ce939ab-cbeb-4f20-9626-be32313723bc \
  --display-name "s3-documents" \
  --type S3 \
  --configuration '{"connectionConfiguration":{"repositoryEndpointMetadata":{"bucketName":"YOUR-BUCKET-NAME"}}}' \
  --region us-west-2
```

**Option B: Use AWS Console**
1. Go to Amazon Q Business in AWS Console
2. Select your application
3. Navigate to Data Sources
4. Add connectors (S3, SharePoint, Confluence, etc.)

### 3. Set User Password
To enable login for qbusiness-admin:
```bash
# Option 1: Via AWS Console
# Go to IAM Identity Center → Users → qbusiness-admin → Reset Password

# Option 2: Create one-time password
aws identitystore create-user \
  --identity-store-id d-c367615483 \
  --user-name "qbusiness-admin" \
  --region eu-north-1
```

### 4. Test Queries
Once authentication is configured and data sources are added:
1. Log in to the web experience
2. Try sample queries
3. Verify document retrieval and responses

---

## Configuration Files

All deployment artifacts saved to:
- `/tmp/qbusiness-app.json` - Application details
- `/tmp/qbusiness-index.json` - Index configuration
- `/tmp/qbusiness-web-experience.json` - Web experience details

---

## Useful Commands

### Check Application Status
```bash
aws qbusiness get-application \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --region us-west-2
```

### List Data Sources
```bash
aws qbusiness list-data-sources \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --index-id 7ce939ab-cbeb-4f20-9626-be32313723bc \
  --region us-west-2
```

### Check Web Experience
```bash
aws qbusiness get-web-experience \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --web-experience-id 48e43dde-1857-4256-9c79-a71bb6b2b0a0 \
  --region us-west-2
```

### List Users
```bash
aws identitystore list-users \
  --identity-store-id d-c367615483 \
  --region eu-north-1
```

---

## Troubleshooting

### Web Experience Status: PENDING_AUTH_CONFIG
This is expected for new deployments. To resolve:
1. Use AWS Console to complete authentication setup
2. Ensure IAM Identity Center is properly configured
3. Verify user has appropriate permissions

### No Data Sources
Add at least one data source for Q Business to have content to search and answer questions about.

### User Cannot Login
1. Verify user password is set in IAM Identity Center
2. Check that auto-subscription is enabled (✅ confirmed)
3. Ensure user is assigned to the AWS account

---

## Cost Considerations

- Amazon Q Business charges per user per month
- Index capacity: 1 unit (can be scaled)
- Auto-subscription is ENABLED - users will be automatically subscribed
- Monitor usage via AWS Cost Explorer

---

## Support Resources

- [Amazon Q Business Documentation](https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/)
- [IAM Identity Center Guide](https://docs.aws.amazon.com/singlesignon/latest/userguide/)
- AWS Support (if you have a support plan)

