# Amazon Q Business 命令行对话指南

本指南介绍如何在本地计算机通过命令行与 Amazon Q Business 进行对话。

## 📋 前提条件

1. AWS CLI v2 已安装
2. jq (JSON 处理工具) 已安装
3. 已部署 Amazon Q Business 应用
4. 已配置 AWS IAM Identity Center

## 🚀 快速开始

### 步骤 1: 配置 SSO 登录

Amazon Q Business 使用 IAM Identity Center 进行身份验证。首先需要登录：

```bash
# 运行 SSO 登录助手
./sso-login.sh
```

**或者手动登录：**

```bash
# 使用 AWS CLI 登录
aws sso login --profile qbusiness-sso
```

这将打开浏览器窗口，您需要：
1. 访问 SSO 门户: https://d-c367615483.awsapps.com/start
2. 使用 Identity Center 用户凭证登录
3. 选择账户和权限集

### 步骤 2: 开始对话

登录成功后，您可以使用以下两种方式与 Amazon Q Business 对话：

#### 方式 1: 快速单次提问

```bash
./chat-with-sso.sh '你的问题'
```

**示例：**
```bash
./chat-with-sso.sh 'What documents are available in the system?'
./chat-with-sso.sh 'Tell me about CloudSync Pro'
./chat-with-sso.sh 'What is our vacation policy?'
```

#### 方式 2: 交互式多轮对话（推荐）

```bash
./chat-interactive-sso.sh
```

启动后，您可以：
- 直接输入问题进行对话
- 输入 `exit` 或 `quit` 退出
- 输入 `clear` 清空会话历史
- 输入 `help` 查看帮助
- 输入 `status` 查看当前状态

**示例会话：**
```
You: What documents are available?
Q Business: [回复内容...]

You: Tell me more about the first document
Q Business: [回复内容...]

You: exit
```

## 🔧 配置详情

### AWS 配置文件

SSO 配置位于 `~/.aws/config`:

```ini
[profile qbusiness-sso]
sso_session = qbusiness
sso_account_id = 460783431756
sso_role_name = AdministratorAccess
region = us-west-2
output = json

[sso-session qbusiness]
sso_start_url = https://d-c367615483.awsapps.com/start
sso_region = eu-north-1
sso_registration_scopes = sso:account:access
```

### 应用信息

- **Application ID**: `8ea6e006-85cc-47bd-a587-b14bff19884d`
- **Region**: `us-west-2`
- **Identity Center**: `d-c367615483` (eu-north-1)
- **Identity Type**: `AWS_IAM_IDC`

## 📝 可用脚本说明

| 脚本名称 | 用途 | 使用场景 |
|---------|------|---------|
| `sso-login.sh` | SSO 登录助手 | 首次使用或 token 过期时 |
| `chat-with-sso.sh` | 单次提问 | 快速查询单个问题 |
| `chat-interactive-sso.sh` | 交互式对话 | 持续多轮对话 |

## 🔍 常见问题

### 1. SSO Token 过期

**错误信息：**
```
Error loading SSO Token: Token for qbusiness does not exist
```

**解决方法：**
```bash
aws sso login --profile qbusiness-sso
```

### 2. 权限被拒绝

**错误信息：**
```
AccessDeniedException: User is not authorized for this service call
```

**可能原因：**
- 用户未被分配到 Q Business 应用
- SSO 会话过期

**解决方法：**
1. 在 AWS Console 中检查用户是否被分配到应用
2. 重新登录 SSO

### 3. 无法打开浏览器

如果在无浏览器的服务器环境中：

**方法 1: 使用设备代码流程**
```bash
aws sso login --profile qbusiness-sso --no-browser
```
这会显示一个 URL 和代码，您可以在另一台设备上完成登录。

**方法 2: 使用 Web Experience**
直接在浏览器中访问 Q Business Web 界面：
```
https://jcfskw7s.chat.qbusiness.us-west-2.on.aws/
```

## 🌐 Web 界面访问（替代方案）

如果命令行访问遇到问题，您可以直接使用 Web 界面：

**Web Experience URL:**
```
https://jcfskw7s.chat.qbusiness.us-west-2.on.aws/
```

在浏览器中访问此 URL，使用 Identity Center 凭证登录即可。

## 📊 检查状态

### 检查 SSO 登录状态
```bash
aws sts get-caller-identity --profile qbusiness-sso
```

### 检查 Q Business 应用
```bash
aws qbusiness get-application \
  --application-id 8ea6e006-85cc-47bd-a587-b14bff19884d \
  --region us-west-2 \
  --profile qbusiness-sso
```

### 查看会话历史
```bash
# 查看最近的对话响应
cat /tmp/qbusiness-chat-response-sso.json | jq .

# 查看会话 ID
cat /tmp/qbusiness-conversation-id-sso.txt
```

## 🔐 安全注意事项

1. **SSO Token 有效期**: 默认 1 小时，过期后需重新登录
2. **凭证存储**: SSO token 存储在 `~/.aws/sso/cache/`
3. **最小权限原则**: 仅授予必要的权限

## 💡 提示与技巧

1. **保持会话活跃**: 使用交互式脚本可以保持对话上下文
2. **查看参考文档**: 回复中会显示引用的数据源
3. **多轮对话**: 在同一会话中，Q Business 会记住之前的对话内容
4. **清空历史**: 使用 `clear` 命令开始新话题

## 📚 相关资源

- [AWS IAM Identity Center 文档](https://docs.aws.amazon.com/singlesignon/)
- [Amazon Q Business 文档](https://docs.aws.amazon.com/amazonq/)
- [AWS CLI SSO 配置](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-sso.html)

## 🆘 获取帮助

如遇问题，请检查：
1. SSO 登录状态: `./sso-login.sh`
2. AWS 配置: `cat ~/.aws/config`
3. 应用状态: 参考 `check-status.sh`

---

**创建日期**: 2025-10-26
**最后更新**: 2025-10-26
