output "application_id" {
  description = "ID of the Amazon Q Business application"
  value       = data.external.application_id.result.application_id
  depends_on  = [null_resource.qbusiness_application]
}

output "application_role_arn" {
  description = "ARN of the IAM role for the application"
  value       = aws_iam_role.qbusiness_app_role.arn
}

output "datasource_role_arn" {
  description = "ARN of the IAM role for data sources"
  value       = aws_iam_role.qbusiness_datasource_role.arn
}

output "deployment_instructions" {
  description = "Instructions for accessing your Amazon Q Business deployment"
  value       = <<-EOT
    Amazon Q Business has been deployed!

    To access your deployment:
    1. Application ID can be found in: /tmp/qbusiness-app.json
    2. Index ID can be found in: /tmp/qbusiness-index.json
    3. Web Experience URL can be found in: /tmp/qbusiness-web-experience.json

    To get the web experience URL, run:
    jq -r '.webExperienceArn' /tmp/qbusiness-web-experience.json

    Note: You'll need to configure user access via AWS IAM Identity Center.
  EOT
}
