variable "aws_region" {
  description = "AWS region for Amazon Q Business deployment"
  type        = string
  default     = "eu-central-1"
}

variable "identity_center_instance_arn" {
  description = "ARN of the AWS IAM Identity Center instance (required for Amazon Q Business)"
  type        = string
  default     = ""
}

variable "application_name" {
  description = "Name of the Amazon Q Business application"
  type        = string
  default     = "my-qbusiness-app"
}

variable "application_description" {
  description = "Description of the Amazon Q Business application"
  type        = string
  default     = "Amazon Q Business Application deployed via Terraform"
}

variable "web_experience_subtitle" {
  description = "Subtitle for the web experience"
  type        = string
  default     = "AI-powered business assistant"
}

variable "index_capacity_units" {
  description = "Number of capacity units for the index"
  type        = number
  default     = 1
}

variable "create_s3_datasource" {
  description = "Whether to create an S3 data source"
  type        = bool
  default     = false
}

variable "data_source_bucket" {
  description = "S3 bucket name for data source (required if create_s3_datasource is true)"
  type        = string
  default     = ""
}

variable "tags" {
  description = "Tags to apply to all resources"
  type        = map(string)
  default = {
    Environment = "development"
    ManagedBy   = "terraform"
    Project     = "amazon-q-business"
  }
}
